/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.hjq.base.BaseDialog;
import com.hjq.base.BaseDialogFragment;
import com.hjq.base.BaseRecyclerViewAdapter;
import com.hjq.dialog.R;
import com.hjq.dialog.widget.PasswordView;
import java.util.Arrays;
import java.util.LinkedList;

public final class PayPasswordDialog {

    public static interface OnListener {
        public void onCompleted(Dialog var1, String var2);

        public void onCancel(Dialog var1);
    }

    private static final class keyboardAdapter
    extends BaseRecyclerViewAdapter<String, ViewHolder> {
        private keyboardAdapter(Context context) {
            super(context);
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(parent, R.layout.item_dialog_pay_password);
        }

        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            holder.mTextView.setText((CharSequence)this.getItem(position));
            switch (position) {
                case 9: {
                    holder.mTextView.setBackgroundColor(-2762533);
                    holder.mTextView.setVisibility(0);
                    holder.mImageView.setVisibility(8);
                    holder.itemView.setBackgroundColor(-1250068);
                    break;
                }
                case 11: {
                    holder.mTextView.setBackgroundColor(-2762533);
                    holder.mTextView.setVisibility(8);
                    holder.mImageView.setVisibility(0);
                    holder.itemView.setBackgroundResource(R.drawable.dialog_pay_password_item_del_selector);
                    break;
                }
            }
        }

        final class ViewHolder
        extends BaseRecyclerViewAdapter.ViewHolder {
            private TextView mTextView;
            private ImageView mImageView;

            private ViewHolder(ViewGroup parent, int layoutId) {
                super((BaseRecyclerViewAdapter)keyboardAdapter.this, parent, layoutId);
                this.mTextView = (TextView)this.findViewById(R.id.tv_dialog_pay_key);
                this.mImageView = (ImageView)this.findViewById(R.id.iv_dialog_pay_delete);
            }
        }
    }

    public static final class Builder
    extends BaseDialogFragment.Builder<Builder>
    implements BaseRecyclerViewAdapter.OnItemClickListener,
    View.OnClickListener {
        private static final String[] KEYBOARD_TEXT = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "", "0", ""};
        private OnListener mListener;
        private boolean mAutoDismiss = true;
        private PasswordView mPasswordView;
        private RecyclerView mRecyclerView;
        private LinkedList<String> mRecordList = new LinkedList();
        private TextView mTitleView;
        private TextView mSubTitleView;
        private TextView mMoneyView;
        private ImageView mCloseView;

        public Builder(FragmentActivity activity) {
            super(activity);
            this.setContentView(R.layout.dialog_pay_password);
            this.setAnimStyle(BaseDialog.AnimStyle.BOTTOM);
            this.setGravity(80);
            this.setWidth(-1);
            this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_dialog_pay_list);
            this.mPasswordView = (PasswordView)this.findViewById(R.id.pw_dialog_pay_view);
            this.mTitleView = (TextView)this.findViewById(R.id.tv_dialog_pay_title);
            this.mSubTitleView = (TextView)this.findViewById(R.id.tv_dialog_pay_sub_title);
            this.mMoneyView = (TextView)this.findViewById(R.id.tv_dialog_pay_money);
            this.mCloseView = (ImageView)this.findViewById(R.id.iv_dialog_pay_close);
            this.mCloseView.setOnClickListener((View.OnClickListener)this);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 3));
            keyboardAdapter adapter = new keyboardAdapter(this.getContext());
            adapter.setData(Arrays.asList(KEYBOARD_TEXT));
            adapter.setOnItemClickListener(this);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
        }

        public Builder setTitle(int resId) {
            return this.setTitle(this.getText(resId));
        }

        public Builder setTitle(CharSequence title) {
            if (title != null && !"".equals(title.toString())) {
                this.mTitleView.setText(title);
                this.mTitleView.setVisibility(0);
            } else {
                this.mTitleView.setVisibility(8);
            }
            return this;
        }

        public Builder setSubTitle(int resId) {
            return this.setSubTitle(this.getText(resId));
        }

        public Builder setSubTitle(CharSequence subTitle) {
            if (subTitle != null && !"".equals(subTitle.toString())) {
                this.mSubTitleView.setText(subTitle);
                this.mSubTitleView.setVisibility(0);
            } else {
                this.mSubTitleView.setVisibility(8);
            }
            return this;
        }

        public Builder setMoney(int resId) {
            return this.setSubTitle(this.getText(resId));
        }

        public Builder setMoney(CharSequence money) {
            if (money != null && !"".equals(money.toString())) {
                this.mMoneyView.setText(money);
                this.mMoneyView.setVisibility(0);
            } else {
                this.mMoneyView.setVisibility(8);
            }
            return this;
        }

        public Builder setAutoDismiss(boolean dismiss) {
            this.mAutoDismiss = dismiss;
            return this;
        }

        public Builder setListener(OnListener l) {
            this.mListener = l;
            return this;
        }

        public void onItemClick(RecyclerView recyclerView, View itemView, int position) {
            switch (position) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (this.mRecordList.size() < 6) {
                        this.mRecordList.add(KEYBOARD_TEXT[position]);
                    }
                    if (this.mRecordList.size() != 6 || this.mListener == null) break;
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (Builder.this.mAutoDismiss) {
                                Builder.this.dismiss();
                            }
                            StringBuilder password = new StringBuilder();
                            for (String s : Builder.this.mRecordList) {
                                password.append(s);
                            }
                            Builder.this.mListener.onCompleted((Dialog)Builder.this.getDialog(), password.toString());
                        }
                    }, 300L);
                    break;
                }
                case 9: {
                    break;
                }
                case 11: {
                    if (this.mRecordList.size() == 0) break;
                    this.mRecordList.removeLast();
                    break;
                }
            }
            this.mPasswordView.setPassWordLength(this.mRecordList.size());
        }

        public void onClick(View v) {
            if (v == this.mCloseView) {
                if (this.mAutoDismiss) {
                    this.dismiss();
                }
                if (this.mListener != null) {
                    this.mListener.onCancel((Dialog)this.getDialog());
                }
            }
        }
    }
}

