/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.design.widget.TabLayout;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.hjq.base.BaseDialog;
import com.hjq.base.BaseDialogFragment;
import com.hjq.base.BaseRecyclerViewAdapter;
import com.hjq.dialog.R;
import com.hjq.dialog.WaitDialog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class AddressDialog {

    public static interface OnListener {
        public void onSelected(Dialog var1, String var2, String var3, String var4);

        public void onCancel(Dialog var1);
    }

    private static final class ProvinceUtils {
        private ProvinceUtils() {
        }

        private static List<AddressBean> getProvinceList(Context context) {
            try {
                JSONArray jsonArray = new JSONArray(ProvinceUtils.getAssetsString(context, "province.json"));
                int length = jsonArray.length();
                ArrayList<AddressBean> list = new ArrayList<AddressBean>(length);
                for (int i = 0; i < length; ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    list.add(new AddressBean(jsonObject.getString("name"), jsonObject));
                }
                return list;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        private static List<AddressBean> getCityList(JSONObject jsonObject) {
            try {
                JSONArray listCity = jsonObject.getJSONArray("city");
                int length = listCity.length();
                ArrayList<AddressBean> list = new ArrayList<AddressBean>(length);
                for (int i = 0; i < length; ++i) {
                    list.add(new AddressBean(listCity.getJSONObject(i).getString("name"), listCity.getJSONObject(i)));
                }
                return list;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        private static List<AddressBean> getAreaList(JSONObject jsonObject) {
            try {
                JSONArray listArea = jsonObject.getJSONArray("area");
                int length = listArea.length();
                ArrayList<AddressBean> list = new ArrayList<AddressBean>(length);
                for (int i = 0; i < length; ++i) {
                    String string2 = listArea.getString(i);
                    list.add(new AddressBean(string2, null));
                }
                return list;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        private static String getAssetsString(Context context, String file) {
            try {
                int length;
                InputStream inputStream = context.getAssets().open(file);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[512];
                while ((length = inputStream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, length);
                }
                outStream.close();
                inputStream.close();
                return outStream.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static final class AddressBean {
        private String name;
        private JSONObject next;

        private AddressBean(String name, JSONObject next) {
            this.name = name;
            this.next = next;
        }

        private String getName() {
            return this.name;
        }

        private JSONObject getNext() {
            return this.next;
        }
    }

    private static final class AddressDialogAdapter
    extends BaseRecyclerViewAdapter<AddressBean, BaseRecyclerViewAdapter.ViewHolder> {
        private AddressDialogAdapter(Context context) {
            super(context);
        }

        @NonNull
        public BaseRecyclerViewAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int position) {
            TextView textView = new TextView(parent.getContext());
            textView.setGravity(16);
            TypedValue typedValue = new TypedValue();
            if (this.getContext().getTheme().resolveAttribute(16843534, typedValue, true)) {
                if (Build.VERSION.SDK_INT >= 16) {
                    textView.setBackground(this.getDrawable(typedValue.resourceId));
                } else {
                    textView.setBackgroundDrawable(this.getDrawable(typedValue.resourceId));
                }
            }
            textView.setTextColor(-14540254);
            textView.setTextSize(2, 14.0f);
            textView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            textView.setPadding((int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
            return new BaseRecyclerViewAdapter.ViewHolder((BaseRecyclerViewAdapter)this, (View)textView);
        }

        public void onBindViewHolder(@NonNull BaseRecyclerViewAdapter.ViewHolder holder, int position) {
            ((TextView)holder.itemView).setText((CharSequence)((AddressBean)this.getItem(position)).getName());
        }
    }

    public static final class Builder
    extends BaseDialogFragment.Builder<WaitDialog.Builder>
    implements BaseRecyclerViewAdapter.OnItemClickListener,
    View.OnClickListener,
    TabLayout.BaseOnTabSelectedListener,
    Runnable {
        private TextView mTitleView;
        private ImageView mCloseView;
        private TabLayout mTabLayout;
        private RecyclerView mRecyclerView1;
        private RecyclerView mRecyclerView2;
        private RecyclerView mRecyclerView3;
        private ImageView mHintView;
        private AddressDialogAdapter mAdapter1;
        private AddressDialogAdapter mAdapter2;
        private AddressDialogAdapter mAdapter3;
        private OnListener mListener;
        private String mProvince = null;
        private String mCity = null;
        private String mArea = null;
        private boolean mIgnoreArea;

        public Builder(FragmentActivity activity) {
            super(activity);
            this.setContentView(R.layout.dialog_address);
            this.setAnimStyle(BaseDialog.AnimStyle.BOTTOM);
            this.setGravity(80);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            this.setWidth(-1);
            this.setHeight(displayMetrics.heightPixels / 2);
            this.mTitleView = (TextView)this.findViewById(R.id.tv_dialog_address_title);
            this.mCloseView = (ImageView)this.findViewById(R.id.iv_dialog_address_closer);
            this.mTabLayout = (TabLayout)this.findViewById(R.id.tb_dialog_address_tab);
            this.mRecyclerView1 = (RecyclerView)this.findViewById(R.id.rv_dialog_address_list1);
            this.mRecyclerView2 = (RecyclerView)this.findViewById(R.id.rv_dialog_address_list2);
            this.mRecyclerView3 = (RecyclerView)this.findViewById(R.id.rv_dialog_address_list3);
            this.mHintView = (ImageView)this.findViewById(R.id.iv_dialog_address_hint);
            this.mAdapter1 = new AddressDialogAdapter(this.getContext());
            this.mAdapter2 = new AddressDialogAdapter(this.getContext());
            this.mAdapter3 = new AddressDialogAdapter(this.getContext());
            this.mCloseView.setOnClickListener((View.OnClickListener)this);
            this.mAdapter1.setOnItemClickListener(this);
            this.mAdapter2.setOnItemClickListener(this);
            this.mAdapter3.setOnItemClickListener(this);
            this.mRecyclerView1.setAdapter((RecyclerView.Adapter)this.mAdapter1);
            this.mRecyclerView2.setAdapter((RecyclerView.Adapter)this.mAdapter2);
            this.mRecyclerView3.setAdapter((RecyclerView.Adapter)this.mAdapter3);
            this.mTabLayout.addTab(this.mTabLayout.newTab().setText(this.getText(R.string.dialog_select_hint)), true);
            this.mTabLayout.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this);
            this.mAdapter1.setData(ProvinceUtils.getProvinceList(this.getContext()));
        }

        public Builder setTitle(int resId) {
            return this.setTitle(this.getText(resId));
        }

        public Builder setTitle(CharSequence text) {
            this.mTitleView.setText(text);
            return this;
        }

        public Builder setProvince(String name) {
            List data;
            if (name != null && !"".equals(name) && (data = this.mAdapter1.getData()) != null && !data.isEmpty()) {
                for (int i = 0; i < data.size(); ++i) {
                    if (!name.equals(((AddressBean)data.get(i)).getName())) continue;
                    this.onItemClick(this.mRecyclerView1, null, i);
                }
            }
            return this;
        }

        public Builder setCity(String name) {
            List data;
            if (this.mIgnoreArea) {
                throw new IllegalStateException("The selection of county-level regions has been ignored. The designated city cannot be selected");
            }
            if (name != null && !"".equals(name) && (data = this.mAdapter2.getData()) != null && !data.isEmpty()) {
                for (int i = 0; i < data.size(); ++i) {
                    if (!name.equals(((AddressBean)data.get(i)).getName())) continue;
                    this.onItemClick(this.mRecyclerView2, null, i);
                }
            }
            return this;
        }

        public Builder setIgnoreArea() {
            List data = this.mAdapter2.getData();
            if (data != null && !data.isEmpty()) {
                throw new IllegalStateException("Cities have been designated and county-level areas can no longer be ignored");
            }
            this.mIgnoreArea = true;
            return this;
        }

        public Builder setListener(OnListener l) {
            this.mListener = l;
            return this;
        }

        public synchronized void onItemClick(RecyclerView recyclerView, View itemView, int position) {
            if (recyclerView == this.mRecyclerView1) {
                this.mProvince = ((AddressBean)this.mAdapter1.getItem(position)).getName();
                this.mTabLayout.getTabAt(this.mTabLayout.getSelectedTabPosition()).setText((CharSequence)this.mProvince);
                this.mTabLayout.addTab(this.mTabLayout.newTab().setText((CharSequence)this.getContext().getResources().getString(R.string.dialog_select_hint)), true);
                this.mAdapter2.setData(ProvinceUtils.getCityList(((AddressBean)this.mAdapter1.getItem(position)).getNext()));
                this.mRecyclerView1.setVisibility(8);
                this.mRecyclerView2.setVisibility(0);
                if (this.mAdapter2.getItemCount() == 1) {
                    this.onItemClick(this.mRecyclerView2, null, 0);
                }
            } else if (recyclerView == this.mRecyclerView2) {
                this.mCity = ((AddressBean)this.mAdapter2.getItem(position)).getName();
                this.mTabLayout.getTabAt(this.mTabLayout.getSelectedTabPosition()).setText((CharSequence)this.mCity);
                if (this.mIgnoreArea) {
                    if (this.mListener != null) {
                        this.mListener.onSelected((Dialog)this.getDialog(), this.mProvince, this.mCity, this.mArea);
                    }
                    this.postDelayed(this, 300L);
                } else {
                    this.mTabLayout.addTab(this.mTabLayout.newTab().setText(this.getText(R.string.dialog_select_hint)), true);
                    this.mAdapter3.setData(ProvinceUtils.getAreaList(((AddressBean)this.mAdapter2.getItem(position)).getNext()));
                }
                this.mRecyclerView2.setVisibility(8);
                if (this.mIgnoreArea) {
                    this.mHintView.setVisibility(0);
                } else {
                    this.mRecyclerView3.setVisibility(0);
                }
            } else if (recyclerView == this.mRecyclerView3) {
                this.mArea = ((AddressBean)this.mAdapter3.getItem(position)).getName();
                this.mTabLayout.getTabAt(this.mTabLayout.getSelectedTabPosition()).setText((CharSequence)this.mArea);
                this.mRecyclerView3.setVisibility(4);
                this.mHintView.setVisibility(0);
                if (this.mListener != null) {
                    this.mListener.onSelected((Dialog)this.getDialog(), this.mProvince, this.mCity, this.mArea);
                }
                this.postDelayed(this, 300L);
            }
        }

        @Override
        public void run() {
            if (this.getDialogFragment() != null && this.getDialogFragment().isAdded() && this.getDialog() != null && this.getDialog().isShowing()) {
                this.dismiss();
            }
        }

        public void onClick(View v) {
            if (v == this.mCloseView) {
                this.dismiss();
                if (this.mListener != null) {
                    this.mListener.onCancel((Dialog)this.getDialog());
                }
            }
        }

        public void onTabSelected(TabLayout.Tab tab) {
            tab.setText(this.getText(R.string.dialog_select_hint));
            switch (tab.getPosition()) {
                case 0: {
                    this.mArea = null;
                    this.mCity = null;
                    this.mProvince = null;
                    if (this.mTabLayout.getTabAt(2) != null) {
                        this.mTabLayout.removeTabAt(2);
                    }
                    if (this.mTabLayout.getTabAt(1) != null) {
                        this.mTabLayout.removeTabAt(1);
                    }
                    this.mRecyclerView1.setVisibility(0);
                    this.mRecyclerView2.setVisibility(8);
                    this.mRecyclerView3.setVisibility(8);
                    break;
                }
                case 1: {
                    this.mArea = null;
                    this.mCity = null;
                    if (this.mTabLayout.getTabAt(2) != null) {
                        this.mTabLayout.removeTabAt(2);
                    }
                    this.mRecyclerView1.setVisibility(8);
                    this.mRecyclerView2.setVisibility(0);
                    this.mRecyclerView3.setVisibility(8);
                    break;
                }
                case 2: {
                    this.mArea = null;
                    this.mRecyclerView1.setVisibility(8);
                    this.mRecyclerView2.setVisibility(8);
                    this.mRecyclerView3.setVisibility(0);
                    break;
                }
            }
        }

        public void onTabUnselected(TabLayout.Tab tab) {
        }

        public void onTabReselected(TabLayout.Tab tab) {
        }
    }
}

