/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.hjq.dialog.R;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class LoopView
extends View {
    private static final String TAG = "LoopView";
    private ScheduledExecutorService mExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture mScheduledFuture;
    private LoopScrollListener mListener;
    private List<String> mData;
    private Paint mTopBottomTextPaint;
    private Paint mCenterTextPaint;
    private Paint mCenterLinePaint;
    private int mTotalScrollY;
    private GestureDetector mGestureDetector;
    private int mSelectedItem;
    private int mTextSize;
    private int mMaxTextWidth;
    private int mMaxTextHeight;
    private int mTopBottomTextColor;
    private int mCenterTextColor;
    private int mCenterLineColor;
    private float mLineSpacingMultiplier;
    private boolean mCanLoop;
    private float mTopLineY;
    private float mBottomLineY;
    private int mCurrentIndex;
    private int mInitPosition;
    private float mHorizontalPadding;
    private float mVerticalPadding;
    private float mItemHeight;
    private int mDrawItemsCount;
    private String[] mItemTempArray;
    private float mCircularDiameter;
    private float mCircularRadius;

    public LoopView(Context context) {
        this(context, null);
    }

    public LoopView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoopView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.LoopView);
        if (array != null) {
            this.mTopBottomTextColor = array.getColor(R.styleable.LoopView_lv_topBottomTextColor, -5263441);
            this.mCenterTextColor = array.getColor(R.styleable.LoopView_lv_centerTextColor, -13553359);
            this.mCenterLineColor = array.getColor(R.styleable.LoopView_lv_lineColor, -3815995);
            this.mCanLoop = array.getBoolean(R.styleable.LoopView_lv_canLoop, true);
            this.mInitPosition = array.getInt(R.styleable.LoopView_lv_initPosition, -1);
            this.mTextSize = array.getDimensionPixelSize(R.styleable.LoopView_lv_textSize, (int)TypedValue.applyDimension((int)1, (float)18.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics()));
            this.mDrawItemsCount = array.getInt(R.styleable.LoopView_lv_drawItemCount, 7);
            this.mItemTempArray = new String[this.mDrawItemsCount];
            array.recycle();
        }
        this.mLineSpacingMultiplier = 3.0f;
        this.mTopBottomTextPaint = new Paint();
        this.mCenterTextPaint = new Paint();
        this.mCenterLinePaint = new Paint();
        this.setLayerType(1, null);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new LoopViewGestureListener());
        this.mGestureDetector.setIsLongpressEnabled(false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case -2147483648: 
            case 0: {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxTextWidth, (int)0x40000000);
                break;
            }
        }
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: 
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)this.mCircularDiameter), (int)0x40000000);
                break;
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mItemHeight = this.mLineSpacingMultiplier * (float)this.mMaxTextHeight;
        this.mHorizontalPadding = (width - this.mMaxTextWidth) / 2;
        this.mVerticalPadding = ((float)height - this.mCircularDiameter) / 2.0f;
        this.mTopLineY = (this.mCircularDiameter - this.mItemHeight) / 2.0f + this.mVerticalPadding;
        this.mBottomLineY = (this.mCircularDiameter + this.mItemHeight) / 2.0f + this.mVerticalPadding;
    }

    protected void onDraw(Canvas canvas) {
        int count;
        if (this.mData == null) {
            return;
        }
        int mChangingItem = (int)((float)this.mTotalScrollY / this.mItemHeight);
        this.mCurrentIndex = this.mInitPosition + mChangingItem % this.mData.size();
        if (!this.mCanLoop) {
            if (this.mCurrentIndex < 0) {
                this.mCurrentIndex = 0;
            }
            if (this.mCurrentIndex > this.mData.size() - 1) {
                this.mCurrentIndex = this.mData.size() - 1;
            }
        } else {
            if (this.mCurrentIndex < 0) {
                this.mCurrentIndex = this.mData.size() + this.mCurrentIndex;
            }
            if (this.mCurrentIndex > this.mData.size() - 1) {
                this.mCurrentIndex -= this.mData.size();
            }
        }
        for (count = 0; count < this.mDrawItemsCount; ++count) {
            int templateItem = this.mCurrentIndex - (this.mDrawItemsCount / 2 - count);
            if (this.mCanLoop) {
                if (templateItem < 0) {
                    templateItem += this.mData.size();
                }
                if (templateItem > this.mData.size() - 1) {
                    templateItem -= this.mData.size();
                }
                this.mItemTempArray[count] = this.mData.get(templateItem);
                continue;
            }
            this.mItemTempArray[count] = templateItem < 0 ? "" : (templateItem > this.mData.size() - 1 ? "" : this.mData.get(templateItem));
        }
        canvas.drawLine(0.0f, this.mTopLineY, (float)this.getMeasuredWidth(), this.mTopLineY, this.mCenterLinePaint);
        canvas.drawLine(0.0f, this.mBottomLineY, (float)this.getMeasuredWidth(), this.mBottomLineY, this.mCenterLinePaint);
        int changingLeftY = (int)((float)this.mTotalScrollY % this.mItemHeight);
        for (count = 0; count < this.mDrawItemsCount; ++count) {
            canvas.save();
            float itemHeight = (float)this.mMaxTextHeight * this.mLineSpacingMultiplier;
            double radian = (itemHeight * (float)count - (float)changingLeftY) / this.mCircularRadius;
            float angle = (float)(radian * 180.0 / Math.PI);
            if (angle >= 180.0f || angle <= 0.0f) {
                canvas.restore();
                continue;
            }
            float translateY = (float)((double)this.mCircularRadius - Math.cos(radian) * (double)this.mCircularRadius - Math.sin(radian) * (double)this.mMaxTextHeight / 2.0) + this.mVerticalPadding;
            canvas.translate(0.0f, translateY);
            canvas.scale(1.0f, (float)Math.sin(radian));
            if (translateY <= this.mTopLineY) {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mTopLineY - translateY);
                canvas.drawText(this.mItemTempArray[count], this.mHorizontalPadding, (float)this.mMaxTextHeight, this.mTopBottomTextPaint);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.mTopLineY - translateY, (float)this.getMeasuredWidth(), (float)((int)itemHeight));
                canvas.drawText(this.mItemTempArray[count], this.mHorizontalPadding, (float)this.mMaxTextHeight, this.mCenterTextPaint);
                canvas.restore();
            } else if ((float)this.mMaxTextHeight + translateY >= this.mBottomLineY) {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mBottomLineY - translateY);
                canvas.drawText(this.mItemTempArray[count], this.mHorizontalPadding, (float)this.mMaxTextHeight, this.mCenterTextPaint);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.mBottomLineY - translateY, (float)this.getMeasuredWidth(), (float)((int)itemHeight));
                canvas.drawText(this.mItemTempArray[count], this.mHorizontalPadding, (float)this.mMaxTextHeight, this.mTopBottomTextPaint);
                canvas.restore();
            } else if (translateY >= this.mTopLineY && (float)this.mMaxTextHeight + translateY <= this.mBottomLineY) {
                canvas.clipRect(0, 0, this.getMeasuredWidth(), (int)itemHeight);
                canvas.drawText(this.mItemTempArray[count], this.mHorizontalPadding, (float)this.mMaxTextHeight, this.mCenterTextPaint);
                this.mSelectedItem = this.mData.indexOf(this.mItemTempArray[count]);
            }
            canvas.restore();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent motionevent) {
        switch (motionevent.getAction()) {
            default: 
        }
        if (!this.mGestureDetector.onTouchEvent(motionevent)) {
            this.startSmoothScrollTo();
        }
        return true;
    }

    public final void setCanLoop(boolean canLoop) {
        this.mCanLoop = canLoop;
        this.invalidate();
    }

    public final void setTextSize(float size) {
        if (size > 0.0f) {
            this.mTextSize = (int)TypedValue.applyDimension((int)1, (float)size, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        }
    }

    public void setLineSpacingMultiplier(float spacing) {
        this.mLineSpacingMultiplier = spacing;
    }

    public int getSelectedItem() {
        return this.mSelectedItem;
    }

    public void setInitPosition(int initPosition) {
        if (this.mData == null) {
            return;
        }
        if (initPosition > this.mData.size()) {
            initPosition = this.mData.size() - 1;
        }
        this.mInitPosition = initPosition;
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onItemSelect(this, initPosition);
        }
    }

    public void setLoopListener(LoopScrollListener l) {
        this.mListener = l;
    }

    public final void setData(List<String> data) {
        this.mData = data;
        if (this.mData == null) {
            throw new IllegalArgumentException("data list must not be null!");
        }
        this.mTopBottomTextPaint.setColor(this.mTopBottomTextColor);
        this.mTopBottomTextPaint.setAntiAlias(true);
        this.mTopBottomTextPaint.setTypeface(Typeface.MONOSPACE);
        this.mTopBottomTextPaint.setTextSize((float)this.mTextSize);
        this.mCenterTextPaint.setColor(this.mCenterTextColor);
        this.mCenterTextPaint.setAntiAlias(true);
        this.mCenterTextPaint.setTextScaleX(1.05f);
        this.mCenterTextPaint.setTypeface(Typeface.MONOSPACE);
        this.mCenterTextPaint.setTextSize((float)this.mTextSize);
        this.mCenterLinePaint.setColor(this.mCenterLineColor);
        this.mCenterLinePaint.setAntiAlias(true);
        this.mCenterLinePaint.setTypeface(Typeface.MONOSPACE);
        this.mCenterLinePaint.setTextSize((float)this.mTextSize);
        Rect rect = new Rect();
        for (int i = 0; i < this.mData.size(); ++i) {
            String text = this.mData.get(i);
            this.mCenterTextPaint.getTextBounds(text, 0, text.length(), rect);
            int textWidth = rect.width();
            if (textWidth > this.mMaxTextWidth) {
                this.mMaxTextWidth = textWidth;
            }
            Paint.FontMetrics fontMetrics = this.mCenterTextPaint.getFontMetrics();
            this.mMaxTextHeight = (int)(fontMetrics.bottom - fontMetrics.top) * 2 / 3;
        }
        int halfCircumference = (int)((float)this.mMaxTextHeight * this.mLineSpacingMultiplier * (float)(this.mDrawItemsCount - 1));
        this.mCircularDiameter = (int)((double)(halfCircumference * 2) / Math.PI);
        this.mCircularRadius = (int)((double)halfCircumference / Math.PI);
        if (this.mInitPosition == -1) {
            this.mInitPosition = this.mCanLoop ? (this.mData.size() + 1) / 2 : 0;
        }
        this.mCurrentIndex = this.mInitPosition;
        this.invalidate();
    }

    private void cancelSchedule() {
        if (this.mScheduledFuture != null && !this.mScheduledFuture.isCancelled()) {
            this.mScheduledFuture.cancel(true);
            this.mScheduledFuture = null;
        }
    }

    private void startSmoothScrollTo() {
        int offset = (int)((float)this.mTotalScrollY % this.mItemHeight);
        this.cancelSchedule();
        this.mScheduledFuture = this.mExecutor.scheduleWithFixedDelay(new HalfHeightRunnable(offset), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void startSmoothScrollTo(float velocityY) {
        this.cancelSchedule();
        int velocityFling = 20;
        this.mScheduledFuture = this.mExecutor.scheduleWithFixedDelay(new FlingRunnable(velocityY), 0L, velocityFling, TimeUnit.MILLISECONDS);
    }

    public static interface LoopScrollListener {
        public void onItemSelect(LoopView var1, int var2);
    }

    private class FlingRunnable
    implements Runnable {
        float velocity;
        final float velocityY;

        FlingRunnable(float velocityY) {
            this.velocityY = velocityY;
            this.velocity = 2.1474836E9f;
        }

        @Override
        public void run() {
            if (this.velocity == 2.1474836E9f) {
                this.velocity = Math.abs(this.velocityY) > 2000.0f ? (this.velocityY > 0.0f ? 2000.0f : -2000.0f) : this.velocityY;
            }
            Log.i((String)LoopView.TAG, (String)("velocity->" + this.velocity));
            if (Math.abs(this.velocity) >= 0.0f && Math.abs(this.velocity) <= 20.0f) {
                LoopView.this.cancelSchedule();
                LoopView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        LoopView.this.startSmoothScrollTo();
                    }
                });
                return;
            }
            int i = (int)(this.velocity * 10.0f / 1000.0f);
            LoopView.this.mTotalScrollY = LoopView.this.mTotalScrollY - i;
            if (!LoopView.this.mCanLoop) {
                float itemHeight = LoopView.this.mLineSpacingMultiplier * (float)LoopView.this.mMaxTextHeight;
                if (LoopView.this.mTotalScrollY <= (int)((float)(-LoopView.this.mInitPosition) * itemHeight)) {
                    this.velocity = 40.0f;
                    LoopView.this.mTotalScrollY = (int)((float)(-LoopView.this.mInitPosition) * itemHeight);
                } else if (LoopView.this.mTotalScrollY >= (int)((float)(LoopView.this.mData.size() - 1 - LoopView.this.mInitPosition) * itemHeight)) {
                    LoopView.this.mTotalScrollY = (int)((float)(LoopView.this.mData.size() - 1 - LoopView.this.mInitPosition) * itemHeight);
                    this.velocity = -40.0f;
                }
            }
            this.velocity = this.velocity < 0.0f ? (this.velocity += 20.0f) : (this.velocity -= 20.0f);
            LoopView.this.postInvalidate();
        }
    }

    private class HalfHeightRunnable
    implements Runnable {
        int realTotalOffset;
        int realOffset;
        int offset;

        HalfHeightRunnable(int offset) {
            this.offset = offset;
            this.realTotalOffset = Integer.MAX_VALUE;
            this.realOffset = 0;
        }

        @Override
        public void run() {
            if (this.realTotalOffset == Integer.MAX_VALUE) {
                this.realTotalOffset = (float)this.offset > LoopView.this.mItemHeight / 2.0f ? (int)(LoopView.this.mItemHeight - (float)this.offset) : -this.offset;
            }
            this.realOffset = (int)((float)this.realTotalOffset * 0.1f);
            if (this.realOffset == 0) {
                this.realOffset = this.realTotalOffset < 0 ? -1 : 1;
            }
            if (Math.abs(this.realTotalOffset) <= 0) {
                LoopView.this.cancelSchedule();
                LoopView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (LoopView.this.mListener != null) {
                            LoopView.this.postDelayed(new SelectedRunnable(), 200L);
                        }
                    }
                });
            } else {
                LoopView.this.mTotalScrollY = LoopView.this.mTotalScrollY + this.realOffset;
                LoopView.this.postInvalidate();
                this.realTotalOffset -= this.realOffset;
            }
        }
    }

    class SelectedRunnable
    implements Runnable {
        SelectedRunnable() {
        }

        @Override
        public final void run() {
            if (LoopView.this.mListener != null) {
                LoopView.this.mListener.onItemSelect(LoopView.this, LoopView.this.getSelectedItem());
            }
        }
    }

    class LoopViewGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        LoopViewGestureListener() {
        }

        public final boolean onDown(MotionEvent motionevent) {
            LoopView.this.cancelSchedule();
            Log.i((String)LoopView.TAG, (String)"LoopViewGestureListener->onDown");
            return true;
        }

        public final boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            LoopView.this.startSmoothScrollTo(velocityY);
            Log.i((String)LoopView.TAG, (String)"LoopViewGestureListener->onFling");
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            Log.i((String)LoopView.TAG, (String)"LoopViewGestureListener->onScroll");
            LoopView.this.mTotalScrollY = (int)((float)LoopView.this.mTotalScrollY + distanceY);
            if (!LoopView.this.mCanLoop) {
                int initPositionCircleLength = (int)((float)LoopView.this.mInitPosition * LoopView.this.mItemHeight);
                int initPositionStartY = -1 * initPositionCircleLength;
                if (LoopView.this.mTotalScrollY < initPositionStartY) {
                    LoopView.this.mTotalScrollY = initPositionStartY;
                }
                int circleLength = (int)((float)(LoopView.this.mData.size() - 1 - LoopView.this.mInitPosition) * LoopView.this.mItemHeight);
                if (LoopView.this.mTotalScrollY >= circleLength) {
                    LoopView.this.mTotalScrollY = circleLength;
                }
            }
            LoopView.this.invalidate();
            return true;
        }
    }
}

