/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog;

import android.support.v4.app.FragmentActivity;
import android.widget.ImageView;
import android.widget.TextView;
import com.hjq.base.BaseDialog;
import com.hjq.base.BaseDialogFragment;
import com.hjq.dialog.R;

public final class ToastDialog {

    public static enum Type {
        FINISH,
        ERROR,
        WARN;

    }

    public static final class Builder
    extends BaseDialogFragment.Builder<Builder>
    implements Runnable,
    BaseDialog.OnShowListener {
        private TextView mMessageView;
        private ImageView mIconView;
        private Type mType = Type.WARN;
        private int mDuration = 2000;

        public Builder(FragmentActivity activity) {
            super(activity);
            this.setThemeStyle(R.style.TransparentDialogStyle);
            this.setContentView(R.layout.dialog_toast);
            this.setAnimStyle(16973828);
            this.setGravity(17);
            this.setCancelable(false);
            this.mMessageView = (TextView)this.findViewById(R.id.tv_dialog_toast_message);
            this.mIconView = (ImageView)this.findViewById(R.id.iv_dialog_toast_icon);
        }

        public Builder setType(Type type) {
            this.mType = type;
            switch (type) {
                case FINISH: {
                    this.mIconView.setImageResource(R.mipmap.ic_dialog_finish);
                    break;
                }
                case ERROR: {
                    this.mIconView.setImageResource(R.mipmap.ic_dialog_error);
                    break;
                }
                case WARN: {
                    this.mIconView.setImageResource(R.mipmap.ic_dialog_warning);
                }
            }
            return this;
        }

        public Builder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        public Builder setMessage(int resId) {
            return this.setMessage(this.getText(resId));
        }

        public Builder setMessage(CharSequence text) {
            this.mMessageView.setText(text);
            return this;
        }

        public BaseDialog create() {
            if (this.mType == null) {
                throw new IllegalArgumentException("The display type must be specified");
            }
            if ("".equals(this.mMessageView.getText().toString())) {
                throw new IllegalArgumentException("Dialog message not null");
            }
            this.addOnShowListener(this);
            return super.create();
        }

        public void onShow(BaseDialog dialog) {
            this.postDelayed(this, this.mDuration);
        }

        @Override
        public void run() {
            if (this.getDialogFragment() != null && this.getDialogFragment().isAdded() && this.getDialog() != null && this.getDialog().isShowing()) {
                this.dismiss();
            }
        }
    }
}

