/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.widget.TextView;

@SuppressLint(value={"AppCompatCustomView"})
public final class CountdownView
extends TextView
implements Runnable {
    private int mTotalTime = 60;
    private static final String TIME_UNIT = "S";
    private int mCurrentTime;
    private CharSequence mRecordText;
    private boolean mFlag;

    public CountdownView(Context context) {
        super(context);
    }

    public CountdownView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CountdownView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public CountdownView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setTotalTime(int totalTime) {
        this.mTotalTime = totalTime;
    }

    public void resetState() {
        this.mFlag = true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setClickable(true);
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this);
        super.onDetachedFromWindow();
    }

    public boolean performClick() {
        boolean click = super.performClick();
        this.mRecordText = this.getText();
        this.setEnabled(false);
        this.mCurrentTime = this.mTotalTime;
        this.post(this);
        return click;
    }

    @Override
    public void run() {
        if (this.mCurrentTime == 0 || this.mFlag) {
            this.setText(this.mRecordText);
            this.setEnabled(true);
            this.mFlag = false;
        } else {
            --this.mCurrentTime;
            this.setText(this.mCurrentTime + "\t" + TIME_UNIT);
            this.postDelayed(this, 1000L);
        }
    }
}

