/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hjq.base.BaseDialog;
import com.hjq.base.BaseDialogFragment;
import com.hjq.base.BaseRecyclerViewAdapter;
import com.hjq.dialog.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MenuDialog {

    public static interface OnListener {
        public void onSelected(Dialog var1, int var2, String var3);

        public void onCancel(Dialog var1);
    }

    private static final class MenuAdapter
    extends BaseRecyclerViewAdapter<String, ViewHolder> {
        private MenuAdapter(Context context) {
            super(context);
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(parent, R.layout.item_dialog_menu);
        }

        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            holder.mTextView.setText((CharSequence)this.getItem(position));
            if (position == 0) {
                if (this.getItemCount() == 1) {
                    holder.itemView.setBackgroundResource(R.drawable.dialog_menu_item);
                    holder.mView.setVisibility(8);
                } else {
                    holder.itemView.setBackgroundResource(R.drawable.dialog_menu_item_top);
                    holder.mView.setVisibility(0);
                }
            } else if (position == this.getItemCount() - 1) {
                holder.itemView.setBackgroundResource(R.drawable.dialog_menu_item_bottom);
                holder.mView.setVisibility(8);
            } else {
                holder.itemView.setBackgroundResource(R.drawable.dialog_menu_item_middle);
                holder.mView.setVisibility(0);
            }
        }

        final class ViewHolder
        extends BaseRecyclerViewAdapter.ViewHolder {
            private TextView mTextView;
            private View mView;

            private ViewHolder(ViewGroup parent, int layoutId) {
                super((BaseRecyclerViewAdapter)MenuAdapter.this, parent, layoutId);
                this.mTextView = (TextView)this.findViewById(R.id.tv_dialog_menu_name);
                this.mView = this.findViewById(R.id.v_dialog_menu_line);
            }
        }
    }

    public static final class Builder
    extends BaseDialogFragment.Builder<Builder>
    implements View.OnClickListener,
    BaseRecyclerViewAdapter.OnItemClickListener {
        private OnListener mListener;
        private boolean mAutoDismiss = true;
        private RecyclerView mRecyclerView;
        private MenuAdapter mAdapter;
        private TextView mCancelView;

        public Builder(FragmentActivity activity) {
            super(activity);
            this.setContentView(R.layout.dialog_menu);
            this.setAnimStyle(BaseDialog.AnimStyle.BOTTOM);
            this.setGravity(80);
            this.setWidth(-1);
            this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_dialog_menu_list);
            this.mCancelView = (TextView)this.findViewById(R.id.tv_dialog_menu_cancel);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
            this.mAdapter = new MenuAdapter(this.getContext());
            this.mAdapter.setOnItemClickListener(this);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
            this.mCancelView.setOnClickListener((View.OnClickListener)this);
        }

        public Builder setList(int ... resIds) {
            ArrayList<String> data = new ArrayList<String>(resIds.length);
            for (int resId : resIds) {
                data.add(this.getString(resId));
            }
            return this.setList(data);
        }

        public Builder setList(String ... data) {
            return this.setList(Arrays.asList(data));
        }

        public Builder setList(List<String> data) {
            this.mAdapter.setData(data);
            return this;
        }

        public Builder setCancel(int resId) {
            return this.setCancel(this.getText(resId));
        }

        public Builder setCancel(CharSequence text) {
            this.mCancelView.setText(text);
            this.mCancelView.setVisibility(text == null || "".equals(text.toString()) ? 8 : 0);
            return this;
        }

        public Builder setAutoDismiss(boolean dismiss) {
            this.mAutoDismiss = dismiss;
            return this;
        }

        public Builder setListener(OnListener l) {
            this.mListener = l;
            return this;
        }

        public void onClick(View v) {
            if (this.mAutoDismiss) {
                this.dismiss();
            }
            if (v == this.mCancelView && this.mListener != null) {
                this.mListener.onCancel((Dialog)this.getDialog());
            }
        }

        public void onItemClick(RecyclerView recyclerView, View itemView, int position) {
            if (this.mAutoDismiss) {
                this.dismiss();
            }
            if (this.mListener != null) {
                this.mListener.onSelected((Dialog)this.getDialog(), position, (String)this.mAdapter.getItem(position));
            }
        }
    }
}

