/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog;

import android.app.Dialog;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.fragment.app.FragmentActivity;
import com.hjq.base.BaseDialog;
import com.hjq.base.BaseDialogFragment;
import com.hjq.dialog.R;

public final class InputDialog {

    public static interface OnListener {
        public void onConfirm(Dialog var1, String var2);

        public void onCancel(Dialog var1);
    }

    public static final class Builder
    extends BaseDialogFragment.Builder<Builder>
    implements View.OnClickListener,
    BaseDialog.OnShowListener,
    BaseDialog.OnDismissListener {
        private OnListener mListener;
        private boolean mAutoDismiss = true;
        private TextView mTitleView;
        private EditText mInputView;
        private TextView mCancelView;
        private View mLineView;
        private TextView mConfirmView;
        private InputMethodManager mInputManager;

        public Builder(FragmentActivity activity) {
            super(activity);
            this.setContentView(R.layout.dialog_input);
            this.setAnimStyle(BaseDialog.AnimStyle.IOS);
            this.setGravity(17);
            this.mTitleView = (TextView)this.findViewById(R.id.tv_dialog_input_title);
            this.mInputView = (EditText)this.findViewById(R.id.tv_dialog_input_message);
            this.mCancelView = (TextView)this.findViewById(R.id.tv_dialog_input_cancel);
            this.mLineView = this.findViewById(R.id.v_dialog_input_line);
            this.mConfirmView = (TextView)this.findViewById(R.id.tv_dialog_input_confirm);
            this.mCancelView.setOnClickListener((View.OnClickListener)this);
            this.mConfirmView.setOnClickListener((View.OnClickListener)this);
            this.mInputManager = (InputMethodManager)activity.getSystemService("input_method");
        }

        public Builder setTitle(int resId) {
            return this.setTitle(this.getText(resId));
        }

        public Builder setTitle(CharSequence text) {
            this.mTitleView.setText(text);
            return this;
        }

        public Builder setHint(int resId) {
            return this.setHint(this.getText(resId));
        }

        public Builder setHint(CharSequence text) {
            this.mInputView.setHint(text);
            return this;
        }

        public Builder setContent(int resId) {
            return this.setContent(this.getText(resId));
        }

        public Builder setContent(CharSequence text) {
            this.mInputView.setText(text);
            int index = this.mInputView.getText().toString().length();
            if (index > 0) {
                this.mInputView.requestFocus();
                this.mInputView.setSelection(index);
            }
            return this;
        }

        public Builder setCancel(int resId) {
            return this.setCancel(this.getText(resId));
        }

        public Builder setCancel(CharSequence text) {
            this.mCancelView.setText(text);
            this.mCancelView.setVisibility(text == null || "".equals(text.toString()) ? 8 : 0);
            this.mLineView.setVisibility(text == null || "".equals(text.toString()) ? 8 : 0);
            this.mConfirmView.setBackgroundResource(text == null || "".equals(text.toString()) ? R.drawable.dialog_message_one_button : R.drawable.dialog_message_right_button);
            return this;
        }

        public Builder setConfirm(int resId) {
            return this.setConfirm(this.getText(resId));
        }

        public Builder setConfirm(CharSequence text) {
            this.mConfirmView.setText(text);
            return this;
        }

        public Builder setAutoDismiss(boolean dismiss) {
            this.mAutoDismiss = dismiss;
            return this;
        }

        public Builder setListener(OnListener l) {
            this.mListener = l;
            return this;
        }

        public BaseDialog create() {
            if ("".equals(this.mTitleView.getText().toString())) {
                this.mTitleView.setVisibility(8);
            }
            this.addOnShowListener(this);
            this.addOnDismissListener(this);
            return super.create();
        }

        public void onShow(BaseDialog dialog) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Builder.this.mInputManager.showSoftInput((View)Builder.this.mInputView, 0);
                }
            }, 500L);
        }

        public void onDismiss(BaseDialog dialog) {
            this.mInputManager.hideSoftInputFromWindow(this.mInputView.getWindowToken(), 0);
        }

        public void onClick(View v) {
            if (this.mAutoDismiss) {
                this.dismiss();
            }
            if (this.mListener == null) {
                return;
            }
            if (v == this.mConfirmView) {
                this.mListener.onConfirm((Dialog)this.getDialog(), this.mInputView.getText().toString());
            } else if (v == this.mCancelView) {
                this.mListener.onCancel((Dialog)this.getDialog());
            }
        }
    }
}

