/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog;

import android.app.Dialog;
import android.support.v4.app.FragmentActivity;
import com.hjq.dialog.AbsLooperDialog;
import com.hjq.dialog.R;
import com.hjq.dialog.widget.LoopView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public final class DateDialog
extends AbsLooperDialog {
    private static final int START_YEAR = 2012;
    private static final int EDN_YEAR = 2022;

    public static interface OnListener {
        public void onSelected(Dialog var1, int var2, int var3, int var4);

        public void onCancel(Dialog var1);
    }

    public static final class Builder
    extends AbsLooperDialog.Builder<Builder>
    implements LoopView.LoopScrollListener {
        private LoopView mYearView;
        private LoopView mMonthView;
        private LoopView mDayView;
        private OnListener mListener;

        public Builder(FragmentActivity activity) {
            super(activity);
            ArrayList<String> yearList = new ArrayList<String>(10);
            for (int i = 2012; i <= 2022; ++i) {
                yearList.add(i + " " + this.getText(R.string.dialog_date_year));
            }
            ArrayList<String> monthList = new ArrayList<String>(12);
            for (int i = 1; i <= 12; ++i) {
                monthList.add(i + " " + this.getText(R.string.dialog_date_month));
            }
            this.mYearView = this.createLoopView();
            this.mMonthView = this.createLoopView();
            this.mDayView = this.createLoopView();
            this.mYearView.setData(yearList);
            this.mMonthView.setData(monthList);
            this.mYearView.setLoopListener(this);
            this.mMonthView.setLoopListener(this);
            Calendar calendar = Calendar.getInstance();
            this.mYearView.setInitPosition(calendar.get(1) - 2012);
            this.mMonthView.setInitPosition(calendar.get(2));
            this.mDayView.setInitPosition(calendar.get(5) - 1);
        }

        @Override
        public void onItemSelect(LoopView loopView, int position) {
            Calendar calendar = Calendar.getInstance(Locale.CHINA);
            if (loopView == this.mYearView) {
                calendar.set(2012 + this.mYearView.getSelectedItem(), this.mMonthView.getSelectedItem(), 1);
            } else if (loopView == this.mMonthView) {
                calendar.set(2012 + this.mYearView.getSelectedItem(), this.mMonthView.getSelectedItem(), 1);
            }
            int day = calendar.getActualMaximum(5);
            ArrayList<String> dayList = new ArrayList<String>(day);
            for (int i = 1; i <= day; ++i) {
                dayList.add(i + " " + this.getText(R.string.dialog_date_day));
            }
            this.mDayView.setData(dayList);
        }

        public Builder setListener(OnListener l) {
            this.mListener = l;
            return this;
        }

        @Override
        protected void onConfirm() {
            if (this.mListener != null) {
                this.mListener.onSelected((Dialog)this.getDialog(), 2012 + this.mYearView.getSelectedItem(), this.mMonthView.getSelectedItem() + 1, this.mDayView.getSelectedItem() + 1);
            }
            this.dismiss();
        }

        @Override
        protected void onCancel() {
            if (this.mListener != null) {
                this.mListener.onCancel((Dialog)this.getDialog());
            }
            this.dismiss();
        }
    }
}

