/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.hjq.widget.R;
import com.hjq.widget.SimpleLayout;

public final class HintLayout
extends SimpleLayout {
    private ViewGroup mMainLayout;
    private ImageView mImageView;
    private TextView mTextView;

    public HintLayout(@NonNull Context context) {
        super(context);
    }

    public HintLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public HintLayout(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void show() {
        if (this.mMainLayout == null) {
            this.initLayout();
        }
        if (!this.isShow()) {
            this.mMainLayout.setVisibility(0);
        }
    }

    public void hide() {
        if (this.mMainLayout != null && this.isShow()) {
            this.mMainLayout.setVisibility(4);
        }
    }

    public boolean isShow() {
        return this.mMainLayout != null && this.mMainLayout.getVisibility() == 0;
    }

    public void setIcon(@DrawableRes int iconId) {
        this.setIcon(this.getResources().getDrawable(iconId));
    }

    public void setIcon(Drawable drawable) {
        if (this.mImageView != null) {
            this.mImageView.setImageDrawable(drawable);
        }
    }

    public void setHint(@StringRes int textId) {
        this.setHint(this.getResources().getString(textId));
    }

    public void setHint(CharSequence text) {
        if (this.mTextView != null && text != null) {
            this.mTextView.setText(text);
        }
    }

    private void initLayout() {
        this.mMainLayout = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.widget_hint_layout, null);
        this.mImageView = (ImageView)this.mMainLayout.findViewById(R.id.iv_hint_icon);
        this.mTextView = (TextView)this.mMainLayout.findViewById(R.id.iv_hint_text);
        if (this.getBackground() == null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(new int[]{16842836});
            this.setBackground(ta.getDrawable(0));
            ta.recycle();
        }
        this.addView((View)this.mMainLayout);
    }

    public void setBackground(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.setBackground(background);
            this.mMainLayout.setBackground(background);
        } else {
            this.setBackgroundDrawable(background);
            this.mMainLayout.setBackgroundDrawable(background);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isShow()) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }
}

