/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import com.hjq.widget.R;

@SuppressLint(value={"AppCompatCustomView"})
public final class ClearEditText
extends EditText
implements View.OnTouchListener,
View.OnFocusChangeListener,
TextWatcher {
    private Drawable mClearIcon;
    private View.OnTouchListener mOnTouchListener;
    private View.OnFocusChangeListener mOnFocusChangeListener;

    public ClearEditText(Context context) {
        super(context, null);
    }

    public ClearEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public ClearEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    @RequiresApi(api=21)
    public ClearEditText(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context);
    }

    private void initialize(Context context) {
        Drawable wrappedDrawable;
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)R.mipmap.widget_input_delete);
        this.mClearIcon = wrappedDrawable = DrawableCompat.wrap((Drawable)drawable);
        this.mClearIcon.setBounds(0, 0, this.mClearIcon.getIntrinsicWidth(), this.mClearIcon.getIntrinsicHeight());
        this.setClearIconVisible(false);
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        super.addTextChangedListener((TextWatcher)this);
    }

    private void setClearIconVisible(boolean visible) {
        if (this.mClearIcon.isVisible() == visible) {
            return;
        }
        this.mClearIcon.setVisible(visible, false);
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        this.setCompoundDrawables(compoundDrawables[0], compoundDrawables[1], visible ? this.mClearIcon : null, compoundDrawables[3]);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mOnFocusChangeListener = onFocusChangeListener;
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.mOnTouchListener = onTouchListener;
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (hasFocus && this.getText() != null) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
        if (this.mOnFocusChangeListener != null) {
            this.mOnFocusChangeListener.onFocusChange(view, hasFocus);
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int x = (int)motionEvent.getX();
        if (this.mClearIcon.isVisible() && x > this.getWidth() - this.getPaddingRight() - this.mClearIcon.getIntrinsicWidth()) {
            if (motionEvent.getAction() == 1) {
                this.setText("");
            }
            return true;
        }
        return this.mOnTouchListener != null && this.mOnTouchListener.onTouch(view, motionEvent);
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isFocused()) {
            this.setClearIconVisible(s.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }
}

