/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.hjq.widget.R;

public final class NumberProgressBar
extends View {
    private int mTextColor;
    private float mTextSize;
    private int mMaxProgress = 100;
    private int mCurrentProgress = 0;
    private int mReachedBarColor;
    private int mUnreachedBarColor;
    private float mReachedBarHeight;
    private float mUnreachedBarHeight;
    private final Paint mReachedBarPaint;
    private final Paint mUnreachedBarPaint;
    private final Paint mTextPaint;
    private final RectF mReachedBound = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private final RectF mUnreachedBound = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private float mTextOffset;

    public NumberProgressBar(Context context) {
        this(context, null);
    }

    public NumberProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumberProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NumberProgressBar, defStyleAttr, 0);
        this.mReachedBarColor = array.getColor(R.styleable.NumberProgressBar_pb_reachedColor, Color.rgb((int)66, (int)145, (int)241));
        this.mUnreachedBarColor = array.getColor(R.styleable.NumberProgressBar_pb_unreachedColor, Color.rgb((int)204, (int)204, (int)204));
        this.mTextColor = array.getColor(R.styleable.NumberProgressBar_pb_textColor, Color.rgb((int)66, (int)145, (int)241));
        this.mTextSize = array.getDimension(R.styleable.NumberProgressBar_pb_textSize, TypedValue.applyDimension((int)2, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mReachedBarHeight = array.getDimension(R.styleable.NumberProgressBar_pb_reachedHeight, TypedValue.applyDimension((int)1, (float)1.5f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mUnreachedBarHeight = array.getDimension(R.styleable.NumberProgressBar_pb_unreachedHeight, TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mTextOffset = array.getDimension(R.styleable.NumberProgressBar_pb_textOffset, TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.setProgress(array.getInt(R.styleable.NumberProgressBar_pb_progress, 0));
        this.setMax(array.getInt(R.styleable.NumberProgressBar_pb_maxProgress, 100));
        array.recycle();
        this.mReachedBarPaint = new Paint(1);
        this.mReachedBarPaint.setColor(this.mReachedBarColor);
        this.mUnreachedBarPaint = new Paint(1);
        this.mUnreachedBarPaint.setColor(this.mUnreachedBarColor);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setTextSize(this.mTextSize);
    }

    protected int getSuggestedMinimumWidth() {
        return (int)this.mTextSize;
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max((int)this.mTextSize, Math.max((int)this.mReachedBarHeight, (int)this.mUnreachedBarHeight));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case -2147483648: 
            case 0: {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getSuggestedMinimumWidth() + this.getPaddingLeft() + this.getPaddingRight()), (int)0x40000000);
                break;
            }
        }
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: 
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getSuggestedMinimumHeight() + this.getPaddingTop() + this.getPaddingBottom()), (int)0x40000000);
                break;
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        boolean drawUnreachedBar;
        float unreachedBarStart;
        float textStart;
        boolean drawReachedBar;
        String text = this.getProgress() * 100 / this.getMax() + "%";
        float textWidth = this.mTextPaint.measureText(text);
        if (this.getProgress() == 0) {
            drawReachedBar = false;
            textStart = this.getPaddingLeft();
        } else {
            drawReachedBar = true;
            this.mReachedBound.left = this.getPaddingLeft();
            this.mReachedBound.top = (float)this.getHeight() / 2.0f - this.mReachedBarHeight / 2.0f;
            this.mReachedBound.right = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / ((float)this.getMax() * 1.0f) * (float)this.getProgress() - this.mTextOffset + (float)this.getPaddingLeft();
            this.mReachedBound.bottom = (float)this.getHeight() / 2.0f + this.mReachedBarHeight / 2.0f;
            textStart = this.mReachedBound.right + this.mTextOffset;
        }
        float textEnd = (int)((float)this.getHeight() / 2.0f - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
        if (textStart + textWidth >= (float)(this.getWidth() - this.getPaddingRight())) {
            textStart = (float)(this.getWidth() - this.getPaddingRight()) - textWidth;
            this.mReachedBound.right = textStart - this.mTextOffset;
        }
        if ((unreachedBarStart = textStart + textWidth + this.mTextOffset) >= (float)(this.getWidth() - this.getPaddingRight())) {
            drawUnreachedBar = false;
        } else {
            drawUnreachedBar = true;
            this.mUnreachedBound.left = unreachedBarStart;
            this.mUnreachedBound.right = this.getWidth() - this.getPaddingRight();
            this.mUnreachedBound.top = (float)this.getHeight() / 2.0f + -this.mUnreachedBarHeight / 2.0f;
            this.mUnreachedBound.bottom = (float)this.getHeight() / 2.0f + this.mUnreachedBarHeight / 2.0f;
        }
        if (drawReachedBar) {
            canvas.drawRect(this.mReachedBound, this.mReachedBarPaint);
        }
        if (drawUnreachedBar) {
            canvas.drawRect(this.mUnreachedBound, this.mUnreachedBarPaint);
        }
        canvas.drawText(text, textStart, textEnd, this.mTextPaint);
    }

    public int getProgress() {
        return this.mCurrentProgress;
    }

    public void setProgress(int progress) {
        if (progress <= this.getMax() && progress >= 0) {
            this.mCurrentProgress = progress;
            this.invalidate();
        }
    }

    public int getMax() {
        return this.mMaxProgress;
    }

    public void setMax(int maxProgress) {
        if (maxProgress > 0) {
            this.mMaxProgress = maxProgress;
            this.invalidate();
        }
    }

    public float getReachedBarHeight() {
        return this.mReachedBarHeight;
    }

    public void setReachedBarHeight(float height) {
        this.mReachedBarHeight = height;
    }

    public float getUnreachedBarHeight() {
        return this.mUnreachedBarHeight;
    }

    public void setUnreachedBarHeight(float height) {
        this.mUnreachedBarHeight = height;
    }

    public void setProgressTextColor(int textColor) {
        this.mTextColor = textColor;
        this.mTextPaint.setColor(this.mTextColor);
        this.invalidate();
    }

    public void setProgressTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mTextPaint.setTextSize(this.mTextSize);
        this.invalidate();
    }

    public int getUnreachedBarColor() {
        return this.mUnreachedBarColor;
    }

    public void setUnreachedBarColor(int barColor) {
        this.mUnreachedBarColor = barColor;
        this.mUnreachedBarPaint.setColor(this.mUnreachedBarColor);
        this.invalidate();
    }

    public int getReachedBarColor() {
        return this.mReachedBarColor;
    }

    public void setReachedBarColor(int progressColor) {
        this.mReachedBarColor = progressColor;
        this.mReachedBarPaint.setColor(this.mReachedBarColor);
        this.invalidate();
    }
}

