/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.base;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRecyclerViewAdapter<T, VH extends ViewHolder>
extends RecyclerView.Adapter<VH> {
    private List<T> mDataSet;
    private RecyclerView mRecyclerView;
    private Context mContext;
    private OnItemClickListener mItemClickListener;
    private OnItemLongClickListener mItemLongClickListener;
    private OnScrollingListener mScrollingListener;
    private SparseArray<OnChildClickListener> mChildClickListeners;
    private SparseArray<OnChildLongClickListener> mChildLongClickListeners;
    private ScrollListener mScrollListener;

    public BaseRecyclerViewAdapter(Context context) {
        this.mContext = context;
    }

    public int getItemCount() {
        return this.mDataSet == null ? 0 : this.mDataSet.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public void setData(List<T> data) {
        this.mDataSet = data;
        this.notifyDataSetChanged();
    }

    @Nullable
    public List<T> getData() {
        return this.mDataSet;
    }

    public void addData(List<T> data) {
        if (data == null || data.size() == 0) {
            return;
        }
        if (this.mDataSet == null || this.mDataSet.size() == 0) {
            this.setData(data);
        } else {
            this.mDataSet.addAll(data);
            this.notifyItemRangeInserted(this.mDataSet.size() - data.size(), data.size());
        }
    }

    public void clearData() {
        if (this.mDataSet == null || this.mDataSet.size() == 0) {
            return;
        }
        this.mDataSet.clear();
        this.notifyDataSetChanged();
    }

    public T getItem(int position) {
        return this.mDataSet.get(position);
    }

    public void setItem(int position, T item) {
        if (this.mDataSet == null) {
            this.mDataSet = new ArrayList<T>();
        }
        this.mDataSet.set(position, item);
        this.notifyItemChanged(position);
    }

    public void addItem(T item) {
        if (this.mDataSet == null) {
            this.mDataSet = new ArrayList<T>();
        }
        this.addItem(this.mDataSet.size(), item);
    }

    public void addItem(int position, T item) {
        if (this.mDataSet == null) {
            this.mDataSet = new ArrayList<T>();
        }
        if (position < this.mDataSet.size()) {
            this.mDataSet.add(position, item);
        } else {
            this.mDataSet.add(item);
            position = this.mDataSet.size() - 1;
        }
        this.notifyItemInserted(position);
    }

    public void removeItem(T item) {
        int index = this.mDataSet.indexOf(item);
        if (index != -1) {
            this.removeItem(index);
        }
    }

    public void removeItem(int position) {
        this.mDataSet.remove(position);
        this.notifyItemRemoved(position);
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected Resources getResources() {
        return this.mContext.getResources();
    }

    public String getString(@StringRes int resId) {
        return this.mContext.getString(resId);
    }

    protected int getColor(@ColorRes int id) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.mContext.getColor(id);
        }
        return this.mContext.getResources().getColor(id);
    }

    protected Drawable getDrawable(@DrawableRes int id) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mContext.getDrawable(id);
        }
        return this.mContext.getResources().getDrawable(id);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        RecyclerView.LayoutManager manager;
        this.mRecyclerView = recyclerView;
        if (this.mScrollListener != null) {
            this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.mScrollListener);
        }
        if (this.mRecyclerView.getLayoutManager() == null && (manager = this.getDefaultLayoutManager(this.mContext)) != null) {
            this.mRecyclerView.setLayoutManager(manager);
        }
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        if (this.mScrollListener != null) {
            this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.mScrollListener);
        }
        this.mRecyclerView = null;
    }

    protected RecyclerView.LayoutManager getDefaultLayoutManager(Context context) {
        return new LinearLayoutManager(context);
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.checkRecyclerViewState();
        this.mItemClickListener = l;
    }

    public void setOnChildClickListener(@IdRes int childId, OnChildClickListener l) {
        this.checkRecyclerViewState();
        if (this.mChildClickListeners == null) {
            this.mChildClickListeners = new SparseArray();
        }
        this.mChildClickListeners.put(childId, (Object)l);
    }

    public void setOnItemLongClickListener(OnItemLongClickListener l) {
        this.checkRecyclerViewState();
        this.mItemLongClickListener = l;
    }

    public void setOnChildLongClickListener(@IdRes int childId, OnChildLongClickListener l) {
        this.checkRecyclerViewState();
        if (this.mChildLongClickListeners == null) {
            this.mChildLongClickListeners = new SparseArray();
        }
        this.mChildLongClickListeners.put(childId, (Object)l);
    }

    private void checkRecyclerViewState() {
        if (this.mRecyclerView != null) {
            throw new IllegalStateException("Binding adapters is not allowed before setting listeners");
        }
    }

    public void setOnScrollingListener(OnScrollingListener l) {
        this.mScrollingListener = l;
        if (this.mScrollListener == null) {
            this.mScrollListener = new ScrollListener();
        } else {
            this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.mScrollListener);
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.mScrollListener);
        }
    }

    public static interface OnChildLongClickListener {
        public void onChildLongClick(RecyclerView var1, View var2, int var3);
    }

    public static interface OnChildClickListener {
        public void onChildClick(RecyclerView var1, View var2, int var3);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(RecyclerView var1, View var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(RecyclerView var1, View var2, int var3);
    }

    public static interface OnScrollingListener {
        public void onScrollTop(RecyclerView var1);

        public void onScrollDown(RecyclerView var1);

        public void onScrolling(RecyclerView var1);
    }

    private class ScrollListener
    extends RecyclerView.OnScrollListener {
        private ScrollListener() {
        }

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            if (BaseRecyclerViewAdapter.this.mScrollingListener == null) {
                return;
            }
            if (newState == 0) {
                if (!recyclerView.canScrollVertically(1)) {
                    BaseRecyclerViewAdapter.this.mScrollingListener.onScrollDown(recyclerView);
                } else if (!recyclerView.canScrollVertically(-1)) {
                    BaseRecyclerViewAdapter.this.mScrollingListener.onScrollTop(recyclerView);
                }
            } else if (newState == 1) {
                BaseRecyclerViewAdapter.this.mScrollingListener.onScrolling(recyclerView);
            }
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        private SparseArray<WeakReference<View>> mViews;

        public ViewHolder(ViewGroup parent, int layoutId) {
            this(LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false));
        }

        public ViewHolder(View itemView) {
            super(itemView);
            this.mViews = new SparseArray();
            this.initViewListener();
        }

        private void initViewListener() {
            Object childView;
            int i;
            if (BaseRecyclerViewAdapter.this.mItemClickListener != null) {
                this.getItemView().setOnClickListener((View.OnClickListener)this);
            }
            if (BaseRecyclerViewAdapter.this.mItemLongClickListener != null) {
                this.getItemView().setOnLongClickListener((View.OnLongClickListener)this);
            }
            if (BaseRecyclerViewAdapter.this.mChildClickListeners != null) {
                for (i = 0; i < BaseRecyclerViewAdapter.this.mChildClickListeners.size(); ++i) {
                    childView = this.findViewById(BaseRecyclerViewAdapter.this.mChildClickListeners.keyAt(i));
                    if (childView == null) continue;
                    childView.setOnClickListener((View.OnClickListener)this);
                }
            }
            if (BaseRecyclerViewAdapter.this.mChildLongClickListeners != null) {
                for (i = 0; i < BaseRecyclerViewAdapter.this.mChildLongClickListeners.size(); ++i) {
                    childView = this.findViewById(BaseRecyclerViewAdapter.this.mChildLongClickListeners.keyAt(i));
                    if (childView == null) continue;
                    childView.setOnLongClickListener((View.OnLongClickListener)this);
                }
            }
        }

        public void onClick(View v) {
            OnChildClickListener childClickListener;
            if (v == this.getItemView() && BaseRecyclerViewAdapter.this.mItemClickListener != null) {
                BaseRecyclerViewAdapter.this.mItemClickListener.onItemClick(BaseRecyclerViewAdapter.this.mRecyclerView, v, this.getLayoutPosition());
                return;
            }
            if (BaseRecyclerViewAdapter.this.mChildClickListeners != null && (childClickListener = (OnChildClickListener)BaseRecyclerViewAdapter.this.mChildClickListeners.get(v.getId())) != null) {
                childClickListener.onChildClick(BaseRecyclerViewAdapter.this.mRecyclerView, v, this.getLayoutPosition());
            }
        }

        public boolean onLongClick(View v) {
            OnChildLongClickListener childClickLongListener;
            if (v == this.getItemView() && BaseRecyclerViewAdapter.this.mItemLongClickListener != null) {
                return BaseRecyclerViewAdapter.this.mItemLongClickListener.onItemLongClick(BaseRecyclerViewAdapter.this.mRecyclerView, v, this.getLayoutPosition());
            }
            if (BaseRecyclerViewAdapter.this.mChildLongClickListeners != null && (childClickLongListener = (OnChildLongClickListener)BaseRecyclerViewAdapter.this.mChildLongClickListeners.get(v.getId())) != null) {
                childClickLongListener.onChildLongClick(BaseRecyclerViewAdapter.this.mRecyclerView, v, this.getLayoutPosition());
            }
            return false;
        }

        public final View getItemView() {
            return this.itemView;
        }

        public final <V extends View> V findViewById(@IdRes int viewId) {
            WeakReference reference = (WeakReference)this.mViews.get(viewId);
            if (reference != null && reference.get() != null) {
                return (V)((View)reference.get());
            }
            View view = this.getItemView().findViewById(viewId);
            this.mViews.put(viewId, new WeakReference<View>(view));
            return (V)view;
        }
    }
}

