/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import java.util.Random;

public abstract class BaseActivity
extends AppCompatActivity {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private ActivityCallback mActivityCallback;
    private int mActivityRequestCode;
    private String mStartActivityTag;
    private long mStartActivityTime;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initActivity();
    }

    protected void initActivity() {
        this.initLayout();
        this.initView();
        this.initData();
    }

    protected void initLayout() {
        if (this.getLayoutId() > 0) {
            this.setContentView(this.getLayoutId());
        }
    }

    protected abstract int getLayoutId();

    protected abstract int getTitleId();

    protected abstract void initView();

    protected abstract void initData();

    public void finish() {
        this.hideSoftKeyboard();
        super.finish();
    }

    public final boolean post(Runnable r) {
        return this.postDelayed(r, 0L);
    }

    public final boolean postDelayed(Runnable r, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        return this.postAtTime(r, SystemClock.uptimeMillis() + delayMillis);
    }

    public final boolean postAtTime(Runnable r, long uptimeMillis) {
        return HANDLER.postAtTime(r, (Object)this, uptimeMillis);
    }

    protected void onDestroy() {
        super.onDestroy();
        HANDLER.removeCallbacksAndMessages((Object)this);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    public <A extends BaseActivity> A getActivity() {
        return (A)((Object)this);
    }

    public View getContentView() {
        return this.getWindow().getDecorView();
    }

    public void startActivity(Class<? extends Activity> cls) {
        this.startActivity(new Intent((Context)this, cls));
    }

    public void startActivityFinish(Class<? extends Activity> cls) {
        this.startActivityFinish(new Intent((Context)this, cls));
    }

    public void startActivityFinish(Intent intent) {
        this.startActivity(intent);
        this.finish();
    }

    public void finishResult() {
        this.finishResult(-1, null);
    }

    public void finishResult(int resultCode) {
        this.finishResult(resultCode, null);
    }

    public void finishResult(int resultCode, Intent data) {
        this.setResult(resultCode, data);
        this.finish();
    }

    public void startActivityForResult(Class<? extends Activity> cls, ActivityCallback callback) {
        this.startActivityForResult(new Intent((Context)this, cls), null, callback);
    }

    public void startActivityForResult(Intent intent, ActivityCallback callback) {
        this.startActivityForResult(intent, null, callback);
    }

    public void startActivityForResult(Intent intent, @Nullable Bundle options, ActivityCallback callback) {
        if (this.mActivityCallback != null) {
            throw new IllegalArgumentException("Error, The callback is not over yet");
        }
        this.mActivityCallback = callback;
        this.mActivityRequestCode = new Random().nextInt(255);
        this.startActivityForResult(intent, this.mActivityRequestCode, options);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (this.mActivityCallback != null && this.mActivityRequestCode == requestCode) {
            this.mActivityCallback.onActivityResult(resultCode, data);
            this.mActivityCallback = null;
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void startActivityForResult(Intent intent, int requestCode, @Nullable Bundle options) {
        if (this.startActivitySelfCheck(intent)) {
            this.hideSoftKeyboard();
            super.startActivityForResult(intent, requestCode, options);
        }
    }

    protected boolean startActivitySelfCheck(Intent intent) {
        String tag;
        boolean result = true;
        if (intent.getComponent() != null) {
            tag = intent.getComponent().getClassName();
        } else if (intent.getAction() != null) {
            tag = intent.getAction();
        } else {
            return true;
        }
        if (tag.equals(this.mStartActivityTag) && this.mStartActivityTime >= SystemClock.uptimeMillis() - 500L) {
            result = false;
        }
        this.mStartActivityTag = tag;
        this.mStartActivityTime = SystemClock.uptimeMillis();
        return result;
    }

    private void hideSoftKeyboard() {
        InputMethodManager manager;
        View view = this.getCurrentFocus();
        if (view != null && (manager = (InputMethodManager)this.getSystemService("input_method")) != null) {
            manager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static interface ActivityCallback {
        public void onActivityResult(int var1, @Nullable Intent var2);
    }
}

