/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog;

import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.fragment.app.FragmentActivity;
import com.hjq.base.BaseDialog;
import com.hjq.base.BaseDialogFragment;
import com.hjq.dialog.R;
import com.hjq.dialog.widget.LoopView;

public class AbsLooperDialog {

    public static abstract class Builder<B extends Builder>
    extends BaseDialogFragment.Builder<B>
    implements View.OnClickListener {
        private TextView mCancelView;
        private TextView mTitleView;
        private TextView mConfirmView;
        private LinearLayout mLinearLayout;

        public Builder(FragmentActivity activity) {
            super(activity);
            this.setContentView(R.layout.dialog_wheel);
            this.setAnimStyle(BaseDialog.AnimStyle.BOTTOM);
            this.setGravity(80);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            this.setWidth(-1);
            this.setHeight(-2);
            this.mCancelView = (TextView)this.findViewById(R.id.tv_dialog_wheel_cancel);
            this.mTitleView = (TextView)this.findViewById(R.id.tv_dialog_wheel_title);
            this.mConfirmView = (TextView)this.findViewById(R.id.tv_dialog_wheel_confirm);
            this.mLinearLayout = (LinearLayout)this.findViewById(R.id.ll_dialog_wheel_list);
            this.mCancelView.setOnClickListener((View.OnClickListener)this);
            this.mConfirmView.setOnClickListener((View.OnClickListener)this);
        }

        public B setTitle(int resId) {
            return this.setTitle(this.getContext().getResources().getText(resId));
        }

        public B setTitle(CharSequence text) {
            this.mTitleView.setText(text);
            return (B)((Object)this);
        }

        public B setCancel(int resId) {
            return this.setCancel(this.getText(resId));
        }

        public B setCancel(CharSequence text) {
            this.mCancelView.setText(text);
            return (B)((Object)this);
        }

        public B setConfirm(int resId) {
            return this.setConfirm(this.getText(resId));
        }

        public B setConfirm(CharSequence text) {
            this.mConfirmView.setText(text);
            return (B)((Object)this);
        }

        public void onClick(View v) {
            if (v == this.mCancelView) {
                this.onCancel();
            } else if (v == this.mConfirmView) {
                this.onConfirm();
            }
        }

        protected abstract void onConfirm();

        protected abstract void onCancel();

        protected LoopView createLoopView() {
            LoopView loopView = new LoopView(this.getContext());
            loopView.setTextSize(20.0f);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2);
            layoutParams.weight = 1.0f;
            loopView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mLinearLayout.addView((View)loopView);
            return loopView;
        }
    }
}

