/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.Nullable;

public final class PasswordView
extends View {
    private Paint mPaint;
    private Path mPath;
    private Paint mPointPaint;
    private int mItemWidth = (int)TypedValue.applyDimension((int)1, (float)this.mItemWidth, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private int mItemHeight = (int)TypedValue.applyDimension((int)1, (float)this.mItemHeight, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private static final int POINT_RADIUS = 15;
    private static final int POINT_COLOR = -10066330;
    private static final int STROKE_COLOR = -1250068;
    public static final int PASSWORD_COUNT = 6;
    private int mCurrentIndex = 0;

    public PasswordView(Context context) {
        this(context, null);
    }

    public PasswordView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PasswordView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-1250068);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPath = new Path();
        this.mPath.moveTo(0.0f, 0.0f);
        this.mPath.lineTo((float)(this.mItemWidth * 6), 0.0f);
        this.mPath.lineTo((float)(this.mItemWidth * 6), (float)this.mItemHeight);
        this.mPath.lineTo(0.0f, (float)this.mItemHeight);
        this.mPath.close();
        this.mPointPaint = new Paint();
        this.mPointPaint.setAntiAlias(true);
        this.mPointPaint.setStyle(Paint.Style.FILL);
        this.mPointPaint.setColor(-10066330);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case -2147483648: 
            case 0: {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.mItemWidth * 6), (int)0x40000000);
                break;
            }
        }
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: 
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mItemHeight, (int)0x40000000);
                break;
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setStrokeWidth(5.0f);
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPaint.setStrokeWidth(3.0f);
        for (int index = 1; index < 6; ++index) {
            canvas.drawLine((float)(this.mItemWidth * index), 0.0f, (float)(this.mItemWidth * index), (float)this.mItemHeight, this.mPaint);
        }
        if (this.mCurrentIndex == 0) {
            return;
        }
        for (int i = 1; i <= this.mCurrentIndex; ++i) {
            canvas.drawCircle((float)(i * this.mItemWidth - this.mItemWidth / 2), (float)(this.mItemHeight / 2), 15.0f, this.mPointPaint);
        }
    }

    public void setPassWordLength(int index) {
        this.mCurrentIndex = index;
        this.invalidate();
    }
}

