/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.InputFilter;
import android.text.Spanned;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatEditText;
import com.hjq.widget.R;
import java.util.regex.Pattern;

public class RegexEditText
extends AppCompatEditText
implements InputFilter {
    public static final String REGEX_MOBILE = "[1]\\d{0,10}";
    public static final String REGEX_CHINESE = "[\\u4e00-\\u9fa5]*";
    public static final String REGEX_ENGLISH = "[a-zA-Z]*";
    public static final String REGEX_COUNT = "[1-9]\\d*";
    public static final String REGEX_NAME = "[[\\u4e00-\\u9fa5]*|[a-zA-Z]*|\\d*]*";
    public static final String REGEX_NONNULL = "\\S+";
    private Pattern mPattern;

    public RegexEditText(Context context) {
        super(context);
        this.initialize(context, null);
    }

    public RegexEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public RegexEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    protected void initialize(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.RegexEditText);
        if (array.hasValue(R.styleable.RegexEditText_inputRegex)) {
            this.setInputRegex(array.getString(R.styleable.RegexEditText_inputRegex));
        } else if (array.hasValue(R.styleable.RegexEditText_regexType)) {
            int regexType = array.getInt(R.styleable.RegexEditText_regexType, 0);
            switch (regexType) {
                case 1: {
                    this.setInputRegex(REGEX_MOBILE);
                    break;
                }
                case 2: {
                    this.setInputRegex(REGEX_CHINESE);
                    break;
                }
                case 3: {
                    this.setInputRegex(REGEX_ENGLISH);
                    break;
                }
                case 4: {
                    this.setInputRegex(REGEX_COUNT);
                    break;
                }
                case 5: {
                    this.setInputRegex(REGEX_NAME);
                    break;
                }
                case 6: {
                    this.setInputRegex(REGEX_NONNULL);
                    break;
                }
            }
        }
        array.recycle();
    }

    public boolean hasInputType(int type) {
        return (this.getInputType() & type) != 0;
    }

    public void addInputType(int type) {
        this.setInputType(this.getInputType() | type);
    }

    public void removeInputType(int type) {
        this.setInputType(this.getInputType() & ~type);
    }

    public void setInputRegex(String regex) {
        if (regex == null || "".equals(regex)) {
            return;
        }
        this.mPattern = Pattern.compile(regex);
        this.addFilters(this);
    }

    public String getInputRegex() {
        if (this.mPattern == null) {
            return null;
        }
        return this.mPattern.pattern();
    }

    public void addFilters(InputFilter filter) {
        InputFilter[] newFilters;
        if (filter == null) {
            return;
        }
        InputFilter[] oldFilters = this.getFilters();
        if (oldFilters != null && oldFilters.length > 0) {
            newFilters = new InputFilter[oldFilters.length + 1];
            System.arraycopy(oldFilters, 0, newFilters, 0, oldFilters.length);
            newFilters[oldFilters.length] = filter;
        } else {
            newFilters = new InputFilter[]{filter};
        }
        super.setFilters(newFilters);
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        if (this.mPattern == null) {
            return source;
        }
        String begin = dest.toString().substring(0, dstart);
        String over = dest.toString().substring(dstart + (dend - dstart), dstart + (dest.toString().length() - begin.length()));
        String result = begin + source + over;
        if (dstart > dend - 1) {
            if (this.mPattern.matcher(result).matches()) {
                return source;
            }
        } else if (!this.mPattern.matcher(result).matches() && !"".equals(result)) {
            return dest.toString().substring(dstart, dend);
        }
        return "";
    }
}

