/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.hjq.widget.R;
import com.hjq.widget.RegexEditText;

public class PasswordEditText
extends RegexEditText
implements View.OnTouchListener,
View.OnFocusChangeListener,
TextWatcher {
    private static final int TYPE_VISIBLE = 144;
    private static final int TYPE_INVISIBLE = 128;
    private Drawable mCurrentDrawable;
    private Drawable mVisibleDrawable;
    private Drawable mInvisibleDrawable;
    private View.OnTouchListener mOnTouchListener;
    private View.OnFocusChangeListener mOnFocusChangeListener;

    public PasswordEditText(Context context) {
        super(context);
    }

    public PasswordEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PasswordEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void initialize(Context context, AttributeSet attrs) {
        super.initialize(context, attrs);
        this.mVisibleDrawable = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_input_show));
        this.mVisibleDrawable.setBounds(0, 0, this.mVisibleDrawable.getIntrinsicWidth(), this.mVisibleDrawable.getIntrinsicHeight());
        this.mInvisibleDrawable = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_input_hide));
        this.mInvisibleDrawable.setBounds(0, 0, this.mInvisibleDrawable.getIntrinsicWidth(), this.mInvisibleDrawable.getIntrinsicHeight());
        this.mCurrentDrawable = this.mVisibleDrawable;
        this.addInputType(128);
        if (this.getInputRegex() == null) {
            this.setInputRegex("\\S+");
        }
        this.setDrawableVisible(false);
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        super.addTextChangedListener((TextWatcher)this);
    }

    private void setDrawableVisible(boolean visible) {
        if (this.mCurrentDrawable.isVisible() == visible) {
            return;
        }
        this.mCurrentDrawable.setVisible(visible, false);
        Drawable[] drawables = this.getCompoundDrawables();
        this.setCompoundDrawables(drawables[0], drawables[1], visible ? this.mCurrentDrawable : null, drawables[3]);
    }

    private void refreshDrawableStatus() {
        Drawable[] drawables = this.getCompoundDrawables();
        this.setCompoundDrawables(drawables[0], drawables[1], this.mCurrentDrawable, drawables[3]);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mOnFocusChangeListener = onFocusChangeListener;
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.mOnTouchListener = onTouchListener;
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (hasFocus && this.getText() != null) {
            this.setDrawableVisible(this.getText().length() > 0);
        } else {
            this.setDrawableVisible(false);
        }
        if (this.mOnFocusChangeListener != null) {
            this.mOnFocusChangeListener.onFocusChange(view, hasFocus);
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int x = (int)motionEvent.getX();
        if (this.mCurrentDrawable.isVisible() && x > this.getWidth() - this.getPaddingRight() - this.mCurrentDrawable.getIntrinsicWidth()) {
            if (motionEvent.getAction() == 1) {
                if (this.mCurrentDrawable == this.mVisibleDrawable) {
                    this.mCurrentDrawable = this.mInvisibleDrawable;
                    this.removeInputType(128);
                    this.addInputType(144);
                    this.refreshDrawableStatus();
                } else if (this.mCurrentDrawable == this.mInvisibleDrawable) {
                    this.mCurrentDrawable = this.mVisibleDrawable;
                    this.removeInputType(144);
                    this.addInputType(128);
                    this.refreshDrawableStatus();
                }
                Editable editable = this.getText();
                if (editable != null) {
                    this.setSelection(editable.toString().length());
                }
            }
            return true;
        }
        return this.mOnTouchListener != null && this.mOnTouchListener.onTouch(view, motionEvent);
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isFocused()) {
            this.setDrawableVisible(s.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }
}

