/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.hjq.widget.R;

public final class SettingBar
extends FrameLayout {
    private TextView mLeftView;
    private TextView mRightView;
    private View mLineView;

    public SettingBar(Context context) {
        this(context, null);
    }

    public SettingBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SettingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.widget_setting_bar, (ViewGroup)this);
        this.mLeftView = (TextView)this.findViewById(R.id.tv_setting_bar_left);
        this.mRightView = (TextView)this.findViewById(R.id.tv_setting_bar_right);
        this.mLineView = this.findViewById(R.id.v_setting_bar_line);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.SettingBar);
        if (array.hasValue(R.styleable.SettingBar_bar_leftText)) {
            this.setLeftText(array.getString(R.styleable.SettingBar_bar_leftText));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_rightText)) {
            this.setRightText(array.getString(R.styleable.SettingBar_bar_rightText));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_leftHint)) {
            this.setLeftHint(array.getString(R.styleable.SettingBar_bar_leftHint));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_rightHint)) {
            this.setRightHint(array.getString(R.styleable.SettingBar_bar_rightHint));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_leftIcon)) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(array.getResourceId(R.styleable.SettingBar_bar_leftIcon, 0)));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_rightIcon)) {
            this.setRightIcon(this.getContext().getResources().getDrawable(array.getResourceId(R.styleable.SettingBar_bar_rightIcon, 0)));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_leftColor)) {
            this.setLeftColor(array.getColor(R.styleable.SettingBar_bar_leftColor, 0));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_rightColor)) {
            this.setRightColor(array.getColor(R.styleable.SettingBar_bar_rightColor, 0));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_leftColorHint)) {
            this.setLeftColorHint(array.getColor(R.styleable.SettingBar_bar_leftColorHint, 0));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_leftSize)) {
            this.setLeftSize(0, array.getDimensionPixelSize(R.styleable.SettingBar_bar_leftSize, 0));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_rightSize)) {
            this.setRightSize(0, array.getDimensionPixelSize(R.styleable.SettingBar_bar_rightSize, 0));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_lineColor)) {
            this.setLineDrawable(array.getDrawable(R.styleable.SettingBar_bar_lineColor));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_lineVisible)) {
            this.setLineVisible(array.getBoolean(R.styleable.SettingBar_bar_lineVisible, true));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_lineSize)) {
            this.setLineSize(array.getDimensionPixelSize(R.styleable.SettingBar_bar_lineSize, 0));
        }
        if (array.hasValue(R.styleable.SettingBar_bar_lineMargin)) {
            this.setLineMargin(array.getDimensionPixelSize(R.styleable.SettingBar_bar_lineMargin, 0));
        }
        if (this.getBackground() == null) {
            Drawable drawable2 = this.getContext().getResources().getDrawable(R.drawable.widget_bg_settting_bar_selector);
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground(drawable2);
            } else {
                this.setBackgroundDrawable(drawable2);
            }
        }
        array.recycle();
    }

    public SettingBar setLeftText(int stringId) {
        return this.setLeftText(this.getResources().getString(stringId));
    }

    public SettingBar setLeftText(CharSequence text) {
        this.mLeftView.setText(text);
        return this;
    }

    public CharSequence getLeftText() {
        return this.mLeftView.getText();
    }

    public SettingBar setLeftHint(int stringId) {
        return this.setLeftHint(this.getResources().getString(stringId));
    }

    public SettingBar setLeftHint(CharSequence hint) {
        this.mLeftView.setHint(hint);
        return this;
    }

    public SettingBar setRightText(int stringId) {
        this.setRightText(this.getResources().getString(stringId));
        return this;
    }

    public SettingBar setRightText(CharSequence text) {
        this.mRightView.setText(text);
        return this;
    }

    public CharSequence getRightText() {
        return this.mRightView.getText();
    }

    public SettingBar setRightHint(int stringId) {
        return this.setRightHint(this.getResources().getString(stringId));
    }

    public SettingBar setRightHint(CharSequence hint) {
        this.mRightView.setHint(hint);
        return this;
    }

    public SettingBar setLeftIcon(int iconId) {
        if (iconId > 0) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(iconId));
        }
        return this;
    }

    public SettingBar setLeftIcon(Drawable drawable2) {
        this.mLeftView.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        return this;
    }

    public Drawable getLeftIcon() {
        return this.mLeftView.getCompoundDrawables()[0];
    }

    public SettingBar setRightIcon(int iconId) {
        if (iconId > 0) {
            this.setRightIcon(this.getContext().getResources().getDrawable(iconId));
        }
        return this;
    }

    public SettingBar setRightIcon(Drawable drawable2) {
        this.mRightView.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        return this;
    }

    public Drawable getRightIcon() {
        return this.mRightView.getCompoundDrawables()[2];
    }

    public SettingBar setLeftColor(int color) {
        this.mLeftView.setTextColor(color);
        return this;
    }

    public SettingBar setLeftColorHint(int color) {
        this.mLeftView.setHintTextColor(color);
        return this;
    }

    public SettingBar setRightColor(int color) {
        this.mRightView.setTextColor(color);
        return this;
    }

    public SettingBar setLeftSize(int unit, float size) {
        this.mLeftView.setTextSize(unit, size);
        return this;
    }

    public SettingBar setRightSize(int unit, float size) {
        this.mRightView.setTextSize(unit, size);
        return this;
    }

    public SettingBar setLineVisible(boolean visible) {
        this.mLineView.setVisibility(visible ? 0 : 8);
        return this;
    }

    public SettingBar setLineColor(int color) {
        return this.setLineDrawable((Drawable)new ColorDrawable(color));
    }

    public SettingBar setLineDrawable(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mLineView.setBackground(drawable2);
        } else {
            this.mLineView.setBackgroundDrawable(drawable2);
        }
        return this;
    }

    public SettingBar setLineSize(int size) {
        ViewGroup.LayoutParams layoutParams = this.mLineView.getLayoutParams();
        layoutParams.height = size;
        this.mLineView.setLayoutParams(layoutParams);
        return this;
    }

    public SettingBar setLineMargin(int margin) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mLineView.getLayoutParams();
        params.leftMargin = margin;
        params.rightMargin = margin;
        this.mLineView.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    public TextView getLeftView() {
        return this.mLeftView;
    }

    public TextView getRightView() {
        return this.mRightView;
    }

    public View getLineView() {
        return this.mLineView;
    }
}

