/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.image;

import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.hjq.image.GlideFactory;
import com.hjq.image.ImageFactory;
import com.hjq.image.ImageHandler;

public final class ImageLoader {
    private static ImageFactory sImageFactory;
    private static ImageHandler sImageHandler;

    public static void init(Application application) {
        ImageLoader.init(application, new GlideFactory());
    }

    public static void init(@NonNull Application application, @NonNull ImageFactory factory) {
        sImageFactory = factory;
        sImageHandler = factory.create();
        sImageFactory.init(application, sImageHandler);
    }

    public static void clear(@NonNull Context context) {
        sImageFactory.clear(context);
    }

    public static void loadImage(@NonNull ImageView imageView, String url) {
        ImageLoader.loadImage(imageView.getContext(), imageView, url);
    }

    public static void loadImage(@NonNull Context context, @NonNull ImageView imageView, String url) {
        sImageHandler.loadImage((Object)context, imageView, url);
    }

    public static void loadImage(androidx.fragment.app.Fragment fragment, @NonNull ImageView imageView, String url) {
        sImageHandler.loadImage((Object)fragment, imageView, url);
    }

    public static void loadImage(Fragment fragment, @NonNull ImageView imageView, String url) {
        sImageHandler.loadImage((Object)fragment, imageView, url);
    }

    public static void loadImage(@NonNull ImageView imageView, @DrawableRes int resourceId) {
        ImageLoader.loadImage(imageView.getContext(), imageView, resourceId);
    }

    public static void loadImage(@NonNull Context context, @NonNull ImageView imageView, @DrawableRes int resourceId) {
        sImageHandler.loadImage((Object)context, imageView, resourceId);
    }

    public static void loadImage(androidx.fragment.app.Fragment fragment, @NonNull ImageView imageView, @DrawableRes int resourceId) {
        sImageHandler.loadImage((Object)fragment, imageView, resourceId);
    }

    public static void loadImage(Fragment fragment, @NonNull ImageView imageView, @DrawableRes int resourceId) {
        sImageHandler.loadImage((Object)fragment, imageView, resourceId);
    }

    public static void loadCircleImage(@NonNull ImageView imageView, String url) {
        ImageLoader.loadCircleImage(imageView.getContext(), imageView, url);
    }

    public static void loadCircleImage(@NonNull Context context, @NonNull ImageView imageView, String url) {
        sImageHandler.loadCircleImage((Object)context, imageView, url);
    }

    public static void loadCircleImage(androidx.fragment.app.Fragment fragment, @NonNull ImageView imageView, String url) {
        sImageHandler.loadCircleImage((Object)fragment, imageView, url);
    }

    public static void loadCircleImage(Fragment fragment, @NonNull ImageView imageView, String url) {
        sImageHandler.loadCircleImage((Object)fragment, imageView, url);
    }

    public static void loadCircleImage(@NonNull ImageView imageView, @DrawableRes int resourceId) {
        ImageLoader.loadCircleImage(imageView.getContext(), imageView, resourceId);
    }

    public static void loadCircleImage(@NonNull Context context, @NonNull ImageView imageView, @DrawableRes int resourceId) {
        sImageHandler.loadCircleImage((Object)context, imageView, resourceId);
    }

    public static void loadCircleImage(androidx.fragment.app.Fragment fragment, @NonNull ImageView imageView, @DrawableRes int resourceId) {
        sImageHandler.loadCircleImage((Object)fragment, imageView, resourceId);
    }

    public static void loadCircleImage(Fragment fragment, @NonNull ImageView imageView, @DrawableRes int resourceId) {
        sImageHandler.loadCircleImage((Object)fragment, imageView, resourceId);
    }

    public static void loadRoundImage(@NonNull ImageView imageView, String url, float radius) {
        ImageLoader.loadRoundImage(imageView.getContext(), imageView, url, radius);
    }

    public static void loadRoundImage(@NonNull Context context, @NonNull ImageView imageView, String url, float radius) {
        sImageHandler.loadRoundImage((Object)context, imageView, url, radius);
    }

    public static void loadRoundImage(androidx.fragment.app.Fragment fragment, @NonNull ImageView imageView, String url, float radius) {
        sImageHandler.loadRoundImage((Object)fragment, imageView, url, radius);
    }

    public static void loadRoundImage(Fragment fragment, @NonNull ImageView imageView, String url, float radius) {
        sImageHandler.loadRoundImage((Object)fragment, imageView, url, radius);
    }

    public static void loadRoundImage(@NonNull ImageView imageView, @DrawableRes int resourceId, float radius) {
        ImageLoader.loadRoundImage(imageView.getContext(), imageView, resourceId, radius);
    }

    public static void loadRoundImage(@NonNull Context context, @NonNull ImageView imageView, @DrawableRes int resourceId, float radius) {
        sImageHandler.loadRoundImage((Object)context, imageView, resourceId, radius);
    }

    public static void loadRoundImage(androidx.fragment.app.Fragment fragment, @NonNull ImageView imageView, @DrawableRes int resourceId, float radius) {
        sImageHandler.loadRoundImage((Object)fragment, imageView, resourceId, radius);
    }

    public static void loadRoundImage(Fragment fragment, @NonNull ImageView imageView, @DrawableRes int resourceId, float radius) {
        sImageHandler.loadRoundImage((Object)fragment, imageView, resourceId, radius);
    }
}

