/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.image;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.util.Util;
import com.hjq.image.ImageHandler;
import java.security.MessageDigest;

final class GlideHandler
implements ImageHandler {
    private Drawable mPlaceholder;
    private Drawable mError;

    GlideHandler() {
    }

    void setPlaceholder(Drawable placeholder) {
        this.mPlaceholder = placeholder;
    }

    void setError(Drawable error) {
        this.mError = error;
    }

    @Override
    public void loadImage(Object object, ImageView imageView, String url) {
        if (url != null && !"".equals(url)) {
            this.getGlide(object).load(url.trim()).apply(RequestOptions.errorOf((Drawable)this.mError).placeholder(this.mPlaceholder)).into(imageView);
        }
    }

    @Override
    public void loadImage(Object object, ImageView imageView, int resourceId) {
        this.getGlide(object).load(Integer.valueOf(resourceId)).apply(RequestOptions.errorOf((Drawable)this.mError).placeholder(this.mPlaceholder)).into(imageView);
    }

    @Override
    public void loadCircleImage(Object object, ImageView imageView, String url) {
        if (url != null && !"".equals(url)) {
            this.getGlide(object).load(url.trim()).apply(RequestOptions.errorOf((Drawable)this.mError).placeholder(this.mPlaceholder).transform((Transformation)new CircleTransformation())).into(imageView);
        }
    }

    @Override
    public void loadCircleImage(Object object, ImageView imageView, int resourceId) {
        this.getGlide(object).load(Integer.valueOf(resourceId)).apply(RequestOptions.errorOf((Drawable)this.mError).placeholder(this.mPlaceholder).transform((Transformation)new CircleTransformation())).into(imageView);
    }

    @Override
    public void loadRoundImage(Object object, ImageView imageView, String url, float radius) {
        if (url != null && !"".equals(url)) {
            this.getGlide(object).load(url.trim()).apply(RequestOptions.errorOf((Drawable)this.mError).placeholder(this.mPlaceholder).transform((Transformation)new RadiusTransformation(radius))).into(imageView);
        }
    }

    @Override
    public void loadRoundImage(Object object, ImageView imageView, int resourceId, float radius) {
        this.getGlide(object).load(Integer.valueOf(resourceId)).apply(RequestOptions.errorOf((Drawable)this.mError).placeholder(this.mPlaceholder).transform((Transformation)new RadiusTransformation(radius))).into(imageView);
    }

    private RequestManager getGlide(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("You cannot start a load on a null Context");
        }
        if (object instanceof Context) {
            if (object instanceof FragmentActivity) {
                return Glide.with((FragmentActivity)((FragmentActivity)object));
            }
            if (object instanceof Activity) {
                return Glide.with((Activity)((Activity)object));
            }
            return Glide.with((Context)((Context)object));
        }
        if (object instanceof Fragment) {
            return Glide.with((Fragment)((Fragment)object));
        }
        if (object instanceof Fragment) {
            return Glide.with((Fragment)((Fragment)object));
        }
        throw new IllegalArgumentException("This object is illegal");
    }

    private static final class RadiusTransformation
    extends BitmapTransformation {
        private final String ID = ((Object)((Object)this)).getClass().getName();
        private float radius;

        RadiusTransformation(float radius) {
            this.radius = radius;
        }

        protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
            int width = toTransform.getWidth();
            int height = toTransform.getHeight();
            Bitmap bitmap = pool.get(width, height, Bitmap.Config.ARGB_8888);
            bitmap.setHasAlpha(true);
            Canvas canvas = new Canvas(bitmap);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setShader((Shader)new BitmapShader(toTransform, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), this.radius, this.radius, paint);
            return bitmap;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RadiusTransformation) {
                RadiusTransformation other = (RadiusTransformation)((Object)obj);
                return this.radius == other.radius;
            }
            return false;
        }

        public int hashCode() {
            return Util.hashCode((int)this.ID.hashCode(), (int)Util.hashCode((float)this.radius));
        }

        public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
            messageDigest.update((this.ID + this.radius).getBytes(CHARSET));
        }
    }

    private static final class CircleTransformation
    extends BitmapTransformation {
        private final String ID = ((Object)((Object)this)).getClass().getName();

        private CircleTransformation() {
        }

        protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
            int size = Math.min(toTransform.getWidth(), toTransform.getHeight());
            int x = (toTransform.getWidth() - size) / 2;
            int y = (toTransform.getHeight() - size) / 2;
            Bitmap square = Bitmap.createBitmap((Bitmap)toTransform, (int)x, (int)y, (int)size, (int)size);
            Bitmap circle = pool.get(size, size, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(circle);
            Paint paint = new Paint();
            paint.setShader((Shader)new BitmapShader(square, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            paint.setAntiAlias(true);
            float r = (float)size / 2.0f;
            canvas.drawCircle(r, r, r, paint);
            return circle;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CircleTransformation) {
                return this == obj;
            }
            return false;
        }

        public int hashCode() {
            return Util.hashCode((int)this.ID.hashCode());
        }

        public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
            messageDigest.update(this.ID.getBytes(CHARSET));
        }
    }
}

