/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog;

import android.app.Dialog;
import android.view.View;
import android.widget.TextView;
import androidx.fragment.app.FragmentActivity;
import com.hjq.base.BaseDialog;
import com.hjq.base.BaseDialogFragment;
import com.hjq.dialog.R;

public final class MessageDialog {

    public static interface OnListener {
        public void onConfirm(Dialog var1);

        public void onCancel(Dialog var1);
    }

    public static final class Builder
    extends BaseDialogFragment.Builder<Builder>
    implements View.OnClickListener {
        private OnListener mListener;
        private boolean mAutoDismiss = true;
        private TextView mTitleView;
        private TextView mMessageView;
        private TextView mCancelView;
        private View mLineView;
        private TextView mConfirmView;

        public Builder(FragmentActivity activity) {
            super(activity);
            this.setContentView(R.layout.dialog_message);
            this.setAnimStyle(BaseDialog.AnimStyle.BOTTOM);
            this.setGravity(17);
            this.mTitleView = (TextView)this.findViewById(R.id.tv_dialog_message_title);
            this.mMessageView = (TextView)this.findViewById(R.id.tv_dialog_message_message);
            this.mCancelView = (TextView)this.findViewById(R.id.tv_dialog_message_cancel);
            this.mLineView = this.findViewById(R.id.v_dialog_message_line);
            this.mConfirmView = (TextView)this.findViewById(R.id.tv_dialog_message_confirm);
            this.mCancelView.setOnClickListener((View.OnClickListener)this);
            this.mConfirmView.setOnClickListener((View.OnClickListener)this);
        }

        public Builder setTitle(int resId) {
            return this.setTitle(this.getText(resId));
        }

        public Builder setTitle(CharSequence text) {
            this.mTitleView.setText(text);
            return this;
        }

        public Builder setMessage(int resId) {
            return this.setMessage(this.getText(resId));
        }

        public Builder setMessage(CharSequence text) {
            this.mMessageView.setText(text);
            return this;
        }

        public Builder setCancel(int resId) {
            return this.setCancel(this.getText(resId));
        }

        public Builder setCancel(CharSequence text) {
            this.mCancelView.setText(text);
            this.mCancelView.setVisibility(text == null || "".equals(text.toString()) ? 8 : 0);
            this.mLineView.setVisibility(text == null || "".equals(text.toString()) ? 8 : 0);
            this.mConfirmView.setBackgroundResource(text == null || "".equals(text.toString()) ? R.drawable.dialog_message_one_button : R.drawable.dialog_message_right_button);
            return this;
        }

        public Builder setConfirm(int resId) {
            return this.setConfirm(this.getText(resId));
        }

        public Builder setConfirm(CharSequence text) {
            this.mConfirmView.setText(text);
            return this;
        }

        public Builder setAutoDismiss(boolean dismiss) {
            this.mAutoDismiss = dismiss;
            return this;
        }

        public Builder setListener(OnListener l) {
            this.mListener = l;
            return this;
        }

        public BaseDialog create() {
            if ("".equals(this.mTitleView.getText().toString())) {
                this.mTitleView.setVisibility(8);
            }
            if ("".equals(this.mMessageView.getText().toString())) {
                throw new IllegalArgumentException("Dialog message not null");
            }
            return super.create();
        }

        public void onClick(View v) {
            if (this.mAutoDismiss) {
                this.dismiss();
            }
            if (this.mListener == null) {
                return;
            }
            if (v == this.mConfirmView) {
                this.mListener.onConfirm((Dialog)this.getDialog());
            } else if (v == this.mCancelView) {
                this.mListener.onCancel((Dialog)this.getDialog());
            }
        }
    }
}

