/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.base;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseListViewAdapter<T, VH extends ViewHolder>
extends BaseAdapter {
    private List<T> mDataSet;
    private Context mContext;

    public BaseListViewAdapter(Context context) {
        this.mContext = context;
    }

    public int getCount() {
        return this.getItemCount();
    }

    public int getItemCount() {
        return this.mDataSet == null ? 0 : this.mDataSet.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = this.onCreateViewHolder(parent, this.getItemViewType(position));
            holder.getItemView().setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        this.onBindViewHolder(holder, position);
        return holder.getItemView();
    }

    @NonNull
    public abstract VH onCreateViewHolder(@NonNull ViewGroup var1, int var2);

    public abstract void onBindViewHolder(@NonNull VH var1, int var2);

    public void setData(List<T> data) {
        this.mDataSet = data;
        this.notifyDataSetChanged();
    }

    @Nullable
    public List<T> getData() {
        return this.mDataSet;
    }

    public void addData(List<T> data) {
        if (this.mDataSet != null) {
            this.mDataSet.addAll(data);
        } else {
            this.mDataSet = data;
        }
        this.notifyDataSetChanged();
    }

    public void clearData() {
        if (this.mDataSet == null || this.mDataSet.size() == 0) {
            return;
        }
        this.mDataSet.clear();
        this.notifyDataSetChanged();
    }

    public T getItem(int position) {
        return this.mDataSet.get(position);
    }

    public void setItem(int position, T item) {
        if (this.mDataSet == null) {
            this.mDataSet = new ArrayList<T>();
        }
        this.mDataSet.set(position, item);
        this.notifyDataSetChanged();
    }

    public void addItem(T item) {
        if (this.mDataSet == null) {
            this.mDataSet = new ArrayList<T>();
        }
        this.addItem(this.mDataSet.size(), item);
    }

    public void addItem(int position, T item) {
        if (this.mDataSet == null) {
            this.mDataSet = new ArrayList<T>();
        }
        if (position < this.mDataSet.size()) {
            this.mDataSet.add(position, item);
        } else {
            this.mDataSet.add(item);
        }
        this.notifyDataSetChanged();
    }

    public void removeItem(T item) {
        int index = this.mDataSet.indexOf(item);
        if (index != -1) {
            this.removeItem(index);
        }
    }

    public void removeItem(int position) {
        this.mDataSet.remove(position);
        this.notifyDataSetChanged();
    }

    public Context getContext() {
        return this.mContext;
    }

    public Resources getResources() {
        return this.mContext.getResources();
    }

    public String getString(@StringRes int resId) {
        return this.mContext.getString(resId);
    }

    public int getColor(@ColorRes int id) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.mContext.getColor(id);
        }
        return this.mContext.getResources().getColor(id);
    }

    public Drawable getDrawable(@DrawableRes int id) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mContext.getDrawable(id);
        }
        return this.mContext.getResources().getDrawable(id);
    }

    public class ViewHolder {
        private final View itemView;
        private SparseArray<WeakReference<View>> mViews = new SparseArray();

        public ViewHolder(ViewGroup parent, int layoutId) {
            this(LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false));
        }

        public ViewHolder(View itemView) {
            this.itemView = itemView;
        }

        public final View getItemView() {
            return this.itemView;
        }

        public final <V extends View> V findViewById(@IdRes int id) {
            WeakReference reference = (WeakReference)this.mViews.get(id);
            if (reference != null && reference.get() != null) {
                return (V)((View)reference.get());
            }
            View view = this.itemView.findViewById(id);
            this.mViews.put(id, new WeakReference<View>(view));
            return (V)view;
        }
    }
}

