/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.base;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.hjq.base.BaseDialog;

public class BaseDialogFragment
extends DialogFragment {
    private BaseDialog mDialog;
    private static String sShowTag;
    private static long sLastTime;

    public void show(Fragment fragment) {
        this.show(fragment.getFragmentManager(), fragment.getClass().getName());
    }

    public void show(FragmentActivity activity) {
        this.show(activity.getSupportFragmentManager(), activity.getClass().getName());
    }

    public void show(FragmentManager manager, String tag) {
        if (!this.isRepeatedShow(tag)) {
            super.show(manager, tag);
        }
    }

    public int show(FragmentTransaction transaction, String tag) {
        if (!this.isRepeatedShow(tag)) {
            return super.show(transaction, tag);
        }
        return -1;
    }

    protected boolean isRepeatedShow(String tag) {
        boolean result = tag.equals(sShowTag) && SystemClock.uptimeMillis() - sLastTime < 500L;
        sShowTag = tag;
        sLastTime = SystemClock.uptimeMillis();
        return result;
    }

    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        if (this.mDialog != null) {
            return this.mDialog;
        }
        this.mDialog = new BaseDialog((Context)this.getActivity());
        return this.mDialog;
    }

    public void setDialog(BaseDialog dialog) {
        this.mDialog = dialog;
    }

    public Dialog getDialog() {
        if (this.mDialog != null) {
            return this.mDialog;
        }
        return super.getDialog();
    }

    public static class Builder<B extends BaseDialog.Builder>
    extends BaseDialog.Builder<B> {
        private FragmentActivity mActivity;
        private BaseDialogFragment mDialogFragment;

        public Builder(FragmentActivity activity) {
            super((Context)activity);
            this.mActivity = activity;
        }

        protected FragmentActivity getActivity() {
            return this.mActivity;
        }

        protected BaseDialogFragment getDialogFragment() {
            return this.mDialogFragment;
        }

        protected String getFragmentTag() {
            return this.getClass().getName();
        }

        @Override
        public void dismiss() {
            try {
                this.mDialogFragment.dismiss();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public BaseDialog show() {
            BaseDialog dialog = this.create();
            this.mDialogFragment = new BaseDialogFragment();
            this.mDialogFragment.setDialog(dialog);
            this.mDialogFragment.show(this.mActivity.getSupportFragmentManager(), this.getFragmentTag());
            this.mDialogFragment.setCancelable(this.isCancelable());
            return dialog;
        }
    }
}

