/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.base;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatDialog;
import com.hjq.base.R;
import java.util.ArrayList;
import java.util.List;

public class BaseDialog
extends AppCompatDialog
implements DialogInterface.OnShowListener,
DialogInterface.OnCancelListener,
DialogInterface.OnDismissListener {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private List<OnShowListener> mOnShowListeners;
    private List<OnCancelListener> mOnCancelListeners;
    private List<OnDismissListener> mOnDismissListeners;

    public BaseDialog(Context context) {
        this(context, R.style.BaseDialogStyle);
    }

    public BaseDialog(Context context, int themeResId) {
        super(context, themeResId > 0 ? themeResId : R.style.BaseDialogStyle);
    }

    @Deprecated
    public void setOnShowListener(@Nullable DialogInterface.OnShowListener listener) {
        this.addOnShowListener(new ShowListenerWrapper(listener));
    }

    @Deprecated
    public void setOnCancelListener(@Nullable DialogInterface.OnCancelListener listener) {
        this.addOnCancelListener(new CancelListenerWrapper(listener));
    }

    @Deprecated
    public void setOnDismissListener(@Nullable DialogInterface.OnDismissListener listener) {
        this.addOnDismissListener(new DismissListenerWrapper(listener));
    }

    public void addOnShowListener(@Nullable OnShowListener listener) {
        if (this.mOnShowListeners == null) {
            this.mOnShowListeners = new ArrayList<OnShowListener>();
            super.setOnShowListener((DialogInterface.OnShowListener)this);
        }
        this.mOnShowListeners.add(listener);
    }

    public void addOnCancelListener(@Nullable OnCancelListener listener) {
        if (this.mOnCancelListeners == null) {
            this.mOnCancelListeners = new ArrayList<OnCancelListener>();
            super.setOnCancelListener((DialogInterface.OnCancelListener)this);
        }
        this.mOnCancelListeners.add(listener);
    }

    public void addOnDismissListener(@Nullable OnDismissListener listener) {
        if (this.mOnDismissListeners == null) {
            this.mOnDismissListeners = new ArrayList<OnDismissListener>();
            super.setOnDismissListener((DialogInterface.OnDismissListener)this);
        }
        this.mOnDismissListeners.add(listener);
    }

    private void setOnShowListeners(@Nullable List<OnShowListener> listeners) {
        super.setOnShowListener((DialogInterface.OnShowListener)this);
        this.mOnShowListeners = listeners;
    }

    private void setOnCancelListeners(@Nullable List<OnCancelListener> listeners) {
        super.setOnCancelListener((DialogInterface.OnCancelListener)this);
        this.mOnCancelListeners = listeners;
    }

    private void setOnDismissListeners(@Nullable List<OnDismissListener> listeners) {
        super.setOnDismissListener((DialogInterface.OnDismissListener)this);
        this.mOnDismissListeners = listeners;
    }

    public void onShow(DialogInterface dialog) {
        if (this.mOnShowListeners != null) {
            for (OnShowListener listener : this.mOnShowListeners) {
                listener.onShow(this);
            }
        }
    }

    public void onCancel(DialogInterface dialog) {
        if (this.mOnCancelListeners != null) {
            for (OnCancelListener listener : this.mOnCancelListeners) {
                listener.onCancel(this);
            }
        }
    }

    public void onDismiss(DialogInterface dialog) {
        HANDLER.removeCallbacksAndMessages((Object)this);
        if (this.mOnDismissListeners != null) {
            for (OnDismissListener listener : this.mOnDismissListeners) {
                listener.onDismiss(this);
            }
        }
    }

    public final boolean post(Runnable r) {
        return this.postDelayed(r, 0L);
    }

    public final boolean postDelayed(Runnable r, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        return this.postAtTime(r, SystemClock.uptimeMillis() + delayMillis);
    }

    public final boolean postAtTime(Runnable r, long uptimeMillis) {
        return HANDLER.postAtTime(r, (Object)this, uptimeMillis);
    }

    private static final class DismissListenerWrapper
    implements OnDismissListener {
        private final DialogInterface.OnDismissListener mListener;

        private DismissListenerWrapper(DialogInterface.OnDismissListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onDismiss(BaseDialog dialog) {
            if (this.mListener != null) {
                this.mListener.onDismiss((DialogInterface)dialog);
            }
        }
    }

    private static final class CancelListenerWrapper
    implements OnCancelListener {
        private final DialogInterface.OnCancelListener mListener;

        private CancelListenerWrapper(DialogInterface.OnCancelListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onCancel(BaseDialog dialog) {
            this.mListener.onCancel((DialogInterface)dialog);
        }
    }

    private static final class ShowListenerWrapper
    implements OnShowListener {
        private final DialogInterface.OnShowListener mListener;

        private ShowListenerWrapper(DialogInterface.OnShowListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onShow(BaseDialog dialog) {
            this.mListener.onShow((DialogInterface)dialog);
        }
    }

    private static final class ViewClickWrapper
    implements View.OnClickListener {
        private final BaseDialog mDialog;
        private final OnClickListener mListener;

        private ViewClickWrapper(BaseDialog dialog, OnClickListener listener) {
            this.mDialog = dialog;
            this.mListener = listener;
        }

        public final void onClick(View v) {
            this.mListener.onClick(this.mDialog, v);
        }
    }

    public static interface OnDismissListener {
        public void onDismiss(BaseDialog var1);
    }

    public static interface OnCancelListener {
        public void onCancel(BaseDialog var1);
    }

    public static interface OnShowListener {
        public void onShow(BaseDialog var1);
    }

    public static interface OnClickListener<V extends View> {
        public void onClick(BaseDialog var1, V var2);
    }

    public static class Builder<B extends Builder> {
        protected static final int MATCH_PARENT = -1;
        protected static final int WRAP_CONTENT = -2;
        private BaseDialog mDialog;
        private Context mContext;
        private View mContentView;
        private List<OnShowListener> mOnShowListeners;
        private List<OnCancelListener> mOnCancelListeners;
        private List<OnDismissListener> mOnDismissListeners;
        private DialogInterface.OnKeyListener mOnKeyListener;
        private boolean mCancelable = true;
        private SparseArray<CharSequence> mTextArray = new SparseArray();
        private SparseIntArray mVisibilityArray = new SparseIntArray();
        private SparseArray<Drawable> mBackgroundArray = new SparseArray();
        private SparseArray<Drawable> mImageArray = new SparseArray();
        private SparseArray<OnClickListener> mClickArray = new SparseArray();
        private int mThemeResId = -1;
        private int mAnimations = -1;
        private int mGravity = 17;
        private int mWidth = -2;
        private int mHeight = -2;
        private int mVerticalMargin;
        private int mHorizontalMargin;

        public Builder(Context context) {
            this.mContext = context;
        }

        protected final boolean post(Runnable r) {
            return this.mDialog.post(r);
        }

        protected final boolean postDelayed(Runnable r, long delayMillis) {
            return this.mDialog.postDelayed(r, delayMillis);
        }

        protected final boolean postAtTime(Runnable r, long uptimeMillis) {
            return this.mDialog.postAtTime(r, uptimeMillis);
        }

        protected boolean isCancelable() {
            return this.mCancelable;
        }

        protected Context getContext() {
            return this.mContext;
        }

        protected int getGravity() {
            return this.mGravity;
        }

        protected Resources getResources() {
            return this.mContext.getResources();
        }

        protected CharSequence getText(@StringRes int resId) {
            return this.mContext.getText(resId);
        }

        protected String getString(@StringRes int resId) {
            return this.mContext.getString(resId);
        }

        protected int getColor(@ColorRes int id) {
            if (Build.VERSION.SDK_INT >= 23) {
                return this.mContext.getColor(id);
            }
            return this.mContext.getResources().getColor(id);
        }

        protected Drawable getDrawable(@DrawableRes int id) {
            if (Build.VERSION.SDK_INT >= 21) {
                return this.mContext.getDrawable(id);
            }
            return this.mContext.getResources().getDrawable(id);
        }

        protected <V extends View> V findViewById(@IdRes int id) {
            return (V)this.mContentView.findViewById(id);
        }

        protected BaseDialog getDialog() {
            return this.mDialog;
        }

        protected void dismiss() {
            this.mDialog.dismiss();
        }

        public B setThemeStyle(@StyleRes int themeResId) {
            this.mThemeResId = themeResId;
            return (B)this;
        }

        public B setContentView(@LayoutRes int layoutId) {
            return this.setContentView(LayoutInflater.from((Context)this.mContext).inflate(layoutId, null));
        }

        public B setContentView(@NonNull View view) {
            this.mContentView = view;
            return (B)this;
        }

        public B setGravity(int gravity) {
            if (Build.VERSION.SDK_INT >= 17) {
                gravity = Gravity.getAbsoluteGravity((int)gravity, (int)this.mContext.getResources().getConfiguration().getLayoutDirection());
            }
            this.mGravity = gravity;
            if (this.mAnimations == -1) {
                switch (this.mGravity) {
                    case 48: {
                        this.mAnimations = AnimStyle.TOP;
                        break;
                    }
                    case 80: {
                        this.mAnimations = AnimStyle.BOTTOM;
                        break;
                    }
                    case 3: {
                        this.mAnimations = AnimStyle.LEFT;
                        break;
                    }
                    case 5: {
                        this.mAnimations = AnimStyle.RIGHT;
                    }
                }
            }
            return (B)this;
        }

        public B setWidth(int width) {
            this.mWidth = width;
            return (B)this;
        }

        public B setHeight(int height) {
            this.mHeight = height;
            return (B)this;
        }

        public B setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
            return (B)this;
        }

        public B setAnimStyle(@StyleRes int resId) {
            this.mAnimations = resId;
            return (B)this;
        }

        public B setVerticalMargin(int margin) {
            this.mVerticalMargin = margin;
            return (B)this;
        }

        public B setHorizontalMargin(int margin) {
            this.mHorizontalMargin = margin;
            return (B)this;
        }

        public B addOnShowListener(@NonNull OnShowListener listener) {
            if (this.mOnShowListeners == null) {
                this.mOnShowListeners = new ArrayList<OnShowListener>();
            }
            this.mOnShowListeners.add(listener);
            return (B)this;
        }

        public B addOnCancelListener(@NonNull OnCancelListener listener) {
            if (this.mOnCancelListeners == null) {
                this.mOnCancelListeners = new ArrayList<OnCancelListener>();
            }
            this.mOnCancelListeners.add(listener);
            return (B)this;
        }

        public B addOnDismissListener(@NonNull OnDismissListener listener) {
            if (this.mOnDismissListeners == null) {
                this.mOnDismissListeners = new ArrayList<OnDismissListener>();
            }
            this.mOnDismissListeners.add(listener);
            return (B)this;
        }

        public B setOnKeyListener(@NonNull DialogInterface.OnKeyListener onKeyListener) {
            this.mOnKeyListener = onKeyListener;
            return (B)this;
        }

        public B setText(@IdRes int id, @StringRes int resId) {
            return this.setText(id, this.mContext.getResources().getString(resId));
        }

        public B setText(@IdRes int id, CharSequence text) {
            this.mTextArray.put(id, (Object)text);
            return (B)this;
        }

        public B setVisibility(@IdRes int id, int visibility) {
            this.mVisibilityArray.put(id, visibility);
            return (B)this;
        }

        public B setBackground(@IdRes int id, @DrawableRes int resId) {
            return this.setBackground(id, this.mContext.getResources().getDrawable(resId));
        }

        public B setBackground(@IdRes int id, Drawable drawable) {
            this.mBackgroundArray.put(id, (Object)drawable);
            return (B)this;
        }

        public B setImageDrawable(@IdRes int id, @DrawableRes int resId) {
            return this.setBackground(id, this.mContext.getResources().getDrawable(resId));
        }

        public B setImageDrawable(@IdRes int id, Drawable drawable) {
            this.mImageArray.put(id, (Object)drawable);
            return (B)this;
        }

        public B setOnClickListener(@IdRes int id, @NonNull OnClickListener listener) {
            this.mClickArray.put(id, (Object)listener);
            return (B)this;
        }

        public BaseDialog create() {
            int i;
            if (this.mContentView == null) {
                throw new IllegalArgumentException("Dialog layout cannot be empty");
            }
            ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
            if (layoutParams != null) {
                if (this.mWidth == -2) {
                    this.mWidth = layoutParams.width;
                }
                if (this.mHeight == -2) {
                    this.mHeight = layoutParams.height;
                }
            }
            this.mDialog = this.createDialog(this.mContext, this.mThemeResId);
            this.mDialog.setContentView(this.mContentView);
            this.mDialog.setCancelable(this.mCancelable);
            if (this.mCancelable) {
                this.mDialog.setCanceledOnTouchOutside(true);
            }
            if (this.mOnShowListeners != null) {
                this.mDialog.setOnShowListeners(this.mOnShowListeners);
            }
            if (this.mOnCancelListeners != null) {
                this.mDialog.setOnCancelListeners(this.mOnCancelListeners);
            }
            if (this.mOnDismissListeners != null) {
                this.mDialog.setOnDismissListeners(this.mOnDismissListeners);
            }
            if (this.mOnKeyListener != null) {
                this.mDialog.setOnKeyListener(this.mOnKeyListener);
            }
            if (this.mAnimations == -1) {
                this.mAnimations = AnimStyle.DEFAULT;
            }
            WindowManager.LayoutParams params = this.mDialog.getWindow().getAttributes();
            params.width = this.mWidth;
            params.height = this.mHeight;
            params.gravity = this.mGravity;
            params.windowAnimations = this.mAnimations;
            params.horizontalMargin = this.mHorizontalMargin;
            params.verticalMargin = this.mVerticalMargin;
            this.mDialog.getWindow().setAttributes(params);
            for (i = 0; i < this.mTextArray.size(); ++i) {
                ((TextView)this.mContentView.findViewById(this.mTextArray.keyAt(i))).setText((CharSequence)this.mTextArray.valueAt(i));
            }
            for (i = 0; i < this.mVisibilityArray.size(); ++i) {
                this.mContentView.findViewById(this.mVisibilityArray.keyAt(i)).setVisibility(this.mVisibilityArray.valueAt(i));
            }
            for (i = 0; i < this.mBackgroundArray.size(); ++i) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mContentView.findViewById(this.mBackgroundArray.keyAt(i)).setBackground((Drawable)this.mBackgroundArray.valueAt(i));
                    continue;
                }
                this.mContentView.findViewById(this.mBackgroundArray.keyAt(i)).setBackgroundDrawable((Drawable)this.mBackgroundArray.valueAt(i));
            }
            for (i = 0; i < this.mImageArray.size(); ++i) {
                ((ImageView)this.mContentView.findViewById(this.mImageArray.keyAt(i))).setImageDrawable((Drawable)this.mImageArray.valueAt(i));
            }
            for (i = 0; i < this.mClickArray.size(); ++i) {
                this.mContentView.findViewById(this.mClickArray.keyAt(i)).setOnClickListener((View.OnClickListener)new ViewClickWrapper(this.mDialog, (OnClickListener)this.mClickArray.valueAt(i)));
            }
            return this.mDialog;
        }

        protected BaseDialog createDialog(Context context, int themeResId) {
            return new BaseDialog(context, themeResId);
        }

        public BaseDialog show() {
            BaseDialog dialog = this.create();
            dialog.show();
            return dialog;
        }
    }

    public static final class AnimStyle {
        static final int DEFAULT = R.style.ScaleAnimStyle;
        public static final int SCALE = R.style.ScaleAnimStyle;
        public static final int IOS = R.style.IOSAnimStyle;
        public static final int TOAST = 16973828;
        public static final int TOP = R.style.TopAnimStyle;
        public static final int BOTTOM = R.style.BottomAnimStyle;
        public static final int LEFT = R.style.LeftAnimStyle;
        public static final int RIGHT = R.style.RightAnimStyle;
    }
}

