/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import com.hjq.widget.R;

public final class SwitchButton
extends View {
    private static final int STATE_SWITCH_OFF = 1;
    private static final int STATE_SWITCH_OFF2 = 2;
    private static final int STATE_SWITCH_ON = 3;
    private static final int STATE_SWITCH_ON2 = 4;
    private final AccelerateInterpolator mInterpolator = new AccelerateInterpolator(2.0f);
    private final Paint mPaint = new Paint();
    private final Path mBackgroundPath = new Path();
    private final Path mBarPath = new Path();
    private final RectF mBound = new RectF();
    private float mAnim1;
    private float mAnim2;
    private RadialGradient mShadowGradient;
    protected float mAspectRatio = 0.68f;
    protected float mAnimationSpeed = 0.1f;
    private int mLastCheckedState;
    private int mCheckedState;
    private boolean isCanVisibleDrawing = false;
    protected boolean isShadow;
    protected boolean mChecked;
    protected int mAccentColor = -11806877;
    protected int mPrimaryDarkColor = -12925358;
    protected int mOffColor = -1842205;
    protected int mOffDarkColor = -4210753;
    protected int mShadowColor = -13421773;
    private OnCheckedChangeListener mListener;
    private float mRight;
    private float mCenterX;
    private float mCenterY;
    private float mScale;
    private float mOffset;
    private float mRadius;
    private float mStrokeWidth;
    private float mWidth;
    private float mLeft;
    private float bRight;
    private float mOnLeftX;
    private float mOn2LeftX;
    private float mOff2LeftX;
    private float mOffLeftX;
    private float mShadowReservedHeight;

    public SwitchButton(Context context) {
        super(context);
        this.initialize(null);
    }

    public SwitchButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(attrs);
    }

    public SwitchButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(attrs);
    }

    @RequiresApi(api=21)
    public SwitchButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(attrs);
    }

    private void initialize(AttributeSet attrs) {
        this.setLayerType(1, null);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.SwitchButton);
        this.mChecked = array.getBoolean(R.styleable.SwitchButton_android_checked, this.mChecked);
        this.setEnabled(array.getBoolean(R.styleable.SwitchButton_android_enabled, this.isEnabled()));
        this.mCheckedState = this.mChecked ? 3 : 1;
        this.mLastCheckedState = this.mCheckedState;
        array.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case -2147483648: 
            case 0: {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(TypedValue.applyDimension((int)1, (float)56.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) + (float)this.getPaddingLeft() + (float)this.getPaddingRight())), (int)0x40000000);
                break;
            }
        }
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: 
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) * this.mAspectRatio) + this.getPaddingTop() + this.getPaddingBottom()), (int)0x40000000);
                break;
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        boolean bl = this.isCanVisibleDrawing = w > this.getPaddingLeft() + this.getPaddingRight() && h > this.getPaddingTop() + this.getPaddingBottom();
        if (this.isCanVisibleDrawing) {
            int actuallyDrawingAreaBottom;
            int actuallyDrawingAreaTop;
            int actuallyDrawingAreaRight;
            int actuallyDrawingAreaLeft;
            int actuallyDrawingAreaHeight;
            int actuallyDrawingAreaWidth = w - this.getPaddingLeft() - this.getPaddingRight();
            if ((float)actuallyDrawingAreaWidth * this.mAspectRatio < (float)(actuallyDrawingAreaHeight = h - this.getPaddingTop() - this.getPaddingBottom())) {
                actuallyDrawingAreaLeft = this.getPaddingLeft();
                actuallyDrawingAreaRight = w - this.getPaddingRight();
                int heightExtraSize = (int)((float)actuallyDrawingAreaHeight - (float)actuallyDrawingAreaWidth * this.mAspectRatio);
                actuallyDrawingAreaTop = this.getPaddingTop() + heightExtraSize / 2;
                actuallyDrawingAreaBottom = this.getHeight() - this.getPaddingBottom() - heightExtraSize / 2;
            } else {
                int widthExtraSize = (int)((float)actuallyDrawingAreaWidth - (float)actuallyDrawingAreaHeight / this.mAspectRatio);
                actuallyDrawingAreaLeft = this.getPaddingLeft() + widthExtraSize / 2;
                actuallyDrawingAreaRight = this.getWidth() - this.getPaddingRight() - widthExtraSize / 2;
                actuallyDrawingAreaTop = this.getPaddingTop();
                actuallyDrawingAreaBottom = this.getHeight() - this.getPaddingBottom();
            }
            this.mShadowReservedHeight = (int)((float)(actuallyDrawingAreaBottom - actuallyDrawingAreaTop) * 0.07f);
            float left = actuallyDrawingAreaLeft;
            float top = (float)actuallyDrawingAreaTop + this.mShadowReservedHeight;
            this.mRight = actuallyDrawingAreaRight;
            float bottom = (float)actuallyDrawingAreaBottom - this.mShadowReservedHeight;
            float sHeight = bottom - top;
            this.mCenterX = (this.mRight + left) / 2.0f;
            this.mCenterY = (bottom + top) / 2.0f;
            this.mLeft = left;
            this.mWidth = bottom - top;
            this.bRight = left + this.mWidth;
            float halfHeightOfS = this.mWidth / 2.0f;
            this.mRadius = halfHeightOfS * 0.95f;
            this.mOffset = this.mRadius * 0.2f;
            this.mStrokeWidth = (halfHeightOfS - this.mRadius) * 2.0f;
            this.mOnLeftX = this.mRight - this.mWidth;
            this.mOn2LeftX = this.mOnLeftX - this.mOffset;
            this.mOffLeftX = left;
            this.mOff2LeftX = this.mOffLeftX + this.mOffset;
            this.mScale = 1.0f - this.mStrokeWidth / sHeight;
            this.mBackgroundPath.reset();
            RectF bound = new RectF();
            bound.top = top;
            bound.bottom = bottom;
            bound.left = left;
            bound.right = left + sHeight;
            this.mBackgroundPath.arcTo(bound, 90.0f, 180.0f);
            bound.left = this.mRight - sHeight;
            bound.right = this.mRight;
            this.mBackgroundPath.arcTo(bound, 270.0f, 180.0f);
            this.mBackgroundPath.close();
            this.mBound.left = this.mLeft;
            this.mBound.right = this.bRight;
            this.mBound.top = top + this.mStrokeWidth / 2.0f;
            this.mBound.bottom = bottom - this.mStrokeWidth / 2.0f;
            float bCenterX = (this.bRight + this.mLeft) / 2.0f;
            float bCenterY = (bottom + top) / 2.0f;
            int red = this.mShadowColor >> 16 & 0xFF;
            int green = this.mShadowColor >> 8 & 0xFF;
            int blue = this.mShadowColor & 0xFF;
            this.mShadowGradient = new RadialGradient(bCenterX, bCenterY, this.mRadius, Color.argb((int)200, (int)red, (int)green, (int)blue), Color.argb((int)25, (int)red, (int)green, (int)blue), Shader.TileMode.CLAMP);
        }
    }

    private void calcBPath(float percent) {
        this.mBarPath.reset();
        this.mBound.left = this.mLeft + this.mStrokeWidth / 2.0f;
        this.mBound.right = this.bRight - this.mStrokeWidth / 2.0f;
        this.mBarPath.arcTo(this.mBound, 90.0f, 180.0f);
        this.mBound.left = this.mLeft + percent * this.mOffset + this.mStrokeWidth / 2.0f;
        this.mBound.right = this.bRight + percent * this.mOffset - this.mStrokeWidth / 2.0f;
        this.mBarPath.arcTo(this.mBound, 270.0f, 180.0f);
        this.mBarPath.close();
    }

    private float calcBTranslate(float percent) {
        float result = 0.0f;
        switch (this.mCheckedState - this.mLastCheckedState) {
            case 1: {
                if (this.mCheckedState == 2) {
                    result = this.mOffLeftX;
                    break;
                }
                if (this.mCheckedState != 3) break;
                result = this.mOnLeftX - (this.mOnLeftX - this.mOn2LeftX) * percent;
                break;
            }
            case 2: {
                if (this.mCheckedState == 3) {
                    result = this.mOnLeftX - (this.mOnLeftX - this.mOffLeftX) * percent;
                    break;
                }
                if (this.mCheckedState != 4) break;
                result = this.mOn2LeftX - (this.mOn2LeftX - this.mOffLeftX) * percent;
                break;
            }
            case 3: {
                result = this.mOnLeftX - (this.mOnLeftX - this.mOffLeftX) * percent;
                break;
            }
            case -1: {
                if (this.mCheckedState == 4) {
                    result = this.mOn2LeftX + (this.mOnLeftX - this.mOn2LeftX) * percent;
                    break;
                }
                if (this.mCheckedState != 1) break;
                result = this.mOffLeftX;
                break;
            }
            case -2: {
                if (this.mCheckedState == 1) {
                    result = this.mOffLeftX + (this.mOn2LeftX - this.mOffLeftX) * percent;
                    break;
                }
                if (this.mCheckedState != 2) break;
                result = this.mOff2LeftX + (this.mOnLeftX - this.mOff2LeftX) * percent;
                break;
            }
            case -3: {
                result = this.mOffLeftX + (this.mOnLeftX - this.mOffLeftX) * percent;
                break;
            }
            default: {
                if (this.mCheckedState == 1) {
                    result = this.mOffLeftX;
                    break;
                }
                if (this.mCheckedState != 3) break;
                result = this.mOnLeftX;
            }
        }
        return result - this.mOffLeftX;
    }

    protected void onDraw(Canvas canvas) {
        if (!this.isCanVisibleDrawing) {
            return;
        }
        this.mPaint.setAntiAlias(true);
        boolean isOn = this.mCheckedState == 3 || this.mCheckedState == 4;
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(isOn ? this.mAccentColor : this.mOffColor);
        canvas.drawPath(this.mBackgroundPath, this.mPaint);
        this.mAnim1 = this.mAnim1 - this.mAnimationSpeed > 0.0f ? this.mAnim1 - this.mAnimationSpeed : 0.0f;
        this.mAnim2 = this.mAnim2 - this.mAnimationSpeed > 0.0f ? this.mAnim2 - this.mAnimationSpeed : 0.0f;
        float dsAnim = this.mInterpolator.getInterpolation(this.mAnim1);
        float dbAnim = this.mInterpolator.getInterpolation(this.mAnim2);
        float scale = this.mScale * (isOn ? dsAnim : 1.0f - dsAnim);
        float scaleOffset = (this.mRight - this.mCenterX - this.mRadius) * (isOn ? 1.0f - dsAnim : dsAnim);
        canvas.save();
        canvas.scale(scale, scale, this.mCenterX + scaleOffset, this.mCenterY);
        this.mPaint.setColor(-1);
        canvas.drawPath(this.mBackgroundPath, this.mPaint);
        canvas.restore();
        canvas.save();
        canvas.translate(this.calcBTranslate(dbAnim), this.mShadowReservedHeight);
        boolean isState2 = this.mCheckedState == 4 || this.mCheckedState == 2;
        this.calcBPath(isState2 ? 1.0f - dbAnim : dbAnim);
        if (this.isShadow) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setShader((Shader)this.mShadowGradient);
            canvas.drawPath(this.mBarPath, this.mPaint);
            this.mPaint.setShader(null);
        }
        canvas.translate(0.0f, -this.mShadowReservedHeight);
        canvas.scale(0.98f, 0.98f, this.mWidth / 2.0f, this.mWidth / 2.0f);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(-1);
        canvas.drawPath(this.mBarPath, this.mPaint);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mStrokeWidth * 0.5f);
        this.mPaint.setColor(isOn ? this.mPrimaryDarkColor : this.mOffDarkColor);
        canvas.drawPath(this.mBarPath, this.mPaint);
        canvas.restore();
        this.mPaint.reset();
        if (this.mAnim1 > 0.0f || this.mAnim2 > 0.0f) {
            this.invalidate();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        block10: {
            super.onTouchEvent(event);
            if (!this.isEnabled() || this.mCheckedState != 3 && this.mCheckedState != 1 || this.mAnim1 * this.mAnim2 != 0.0f) return true;
            switch (event.getAction()) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.mLastCheckedState = this.mCheckedState;
                    this.mAnim2 = 1.0f;
                    switch (this.mCheckedState) {
                        case 1: {
                            this.setChecked(true, false);
                            if (this.mListener == null) return true;
                            this.mListener.onCheckedChanged(this, true);
                            break block10;
                        }
                        case 3: {
                            this.setChecked(false, false);
                            if (this.mListener == null) return true;
                            this.mListener.onCheckedChanged(this, false);
                        }
                    }
                }
            }
        }
        return true;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState state = new SavedState(superState);
        state.checked = this.mChecked;
        return state;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mChecked = savedState.checked;
        this.mCheckedState = this.mChecked ? 3 : 1;
        this.invalidate();
    }

    public void setColor(int newColorPrimary, int newColorPrimaryDark) {
        this.setColor(newColorPrimary, newColorPrimaryDark, this.mOffColor, this.mOffDarkColor);
    }

    public void setColor(int newColorPrimary, int newColorPrimaryDark, int newColorOff, int newColorOffDark) {
        this.setColor(newColorPrimary, newColorPrimaryDark, newColorOff, newColorOffDark, this.mShadowColor);
    }

    public void setColor(int newColorPrimary, int newColorPrimaryDark, int newColorOff, int newColorOffDark, int newColorShadow) {
        this.mAccentColor = newColorPrimary;
        this.mPrimaryDarkColor = newColorPrimaryDark;
        this.mOffColor = newColorOff;
        this.mOffDarkColor = newColorOffDark;
        this.mShadowColor = newColorShadow;
        this.invalidate();
    }

    public void setShadow(boolean shadow) {
        this.isShadow = shadow;
        this.invalidate();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.setChecked(checked, true);
    }

    public void setChecked(boolean checked, boolean callback) {
        int newState;
        int n = newState = checked ? 3 : 1;
        if (newState == this.mCheckedState) {
            return;
        }
        if (newState == 3 && (this.mCheckedState == 1 || this.mCheckedState == 2) || newState == 1 && (this.mCheckedState == 3 || this.mCheckedState == 4)) {
            this.mAnim1 = 1.0f;
        }
        this.mAnim2 = 1.0f;
        if (!this.mChecked && newState == 3) {
            this.mChecked = true;
        } else if (this.mChecked && newState == 1) {
            this.mChecked = false;
        }
        this.mLastCheckedState = this.mCheckedState;
        this.mCheckedState = newState;
        this.postInvalidate();
        if (callback && this.mListener != null) {
            this.mListener.onCheckedChanged(this, checked);
        }
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener l) {
        this.mListener = l;
    }

    private static final class SavedState
    extends View.BaseSavedState {
        private boolean checked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checked = 1 == in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.checked ? 1 : 0);
        }

        public int describeContents() {
            return 0;
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(SwitchButton var1, boolean var2);
    }
}

