/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.dialog.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.hjq.dialog.R;

public final class CircleProgressView
extends View {
    public static final long FRAME_DURATION = 16L;
    private static final int MODE_DETERMINATE = 0;
    private static final int MODE_INDETERMINATE = 1;
    private boolean isStart = false;
    private boolean isAutoStart = true;
    private CircularProgressDrawable mCircularProgressDrawable;

    public CircleProgressView(Context context) {
        this(context, null);
    }

    public CircleProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mCircularProgressDrawable = new CircularProgressDrawable.Builder(context, R.style.CircularProgress).build();
        this.setBackground(this.mCircularProgressDrawable);
    }

    public void setBackground(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.setBackground(background);
        } else {
            this.setBackgroundDrawable(background);
        }
    }

    public CircularProgressDrawable getCircularProgressDrawable() {
        return this.mCircularProgressDrawable;
    }

    public void setAutoStart(boolean autoStart) {
        this.isAutoStart = autoStart;
    }

    public void setStrokeSizePx(int px) {
        this.getCircularProgressDrawable().setStrokeSize(px);
    }

    public void setStrokeSizeDp(float dp) {
        this.getCircularProgressDrawable().setStrokeSize((int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics()));
    }

    public void setStrokeColors(int[] strokeColors) {
        this.getCircularProgressDrawable().setStrokeColors(strokeColors);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isAutoStart) {
            this.start();
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (visibility == 8 || visibility == 4 && this.isStart) {
            this.stop();
        } else if (this.isAutoStart) {
            this.start();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.isStart && this.getVisibility() == 0) {
            this.stop();
        }
        super.onDetachedFromWindow();
    }

    public void start() {
        if (this.mCircularProgressDrawable != null) {
            this.mCircularProgressDrawable.start();
            this.isStart = true;
        }
    }

    public void stop() {
        if (this.mCircularProgressDrawable != null && this.isStart) {
            this.mCircularProgressDrawable.stop();
            this.isStart = false;
        }
    }

    private static int getMiddleValue(int prev, int next, float factor) {
        return Math.round((float)prev + (float)(next - prev) * factor);
    }

    public static int getMiddleColor(int prevColor, int curColor, float factor) {
        if (prevColor == curColor) {
            return curColor;
        }
        if (factor == 0.0f) {
            return prevColor;
        }
        if (factor == 1.0f) {
            return curColor;
        }
        int a = CircleProgressView.getMiddleValue(Color.alpha((int)prevColor), Color.alpha((int)curColor), factor);
        int r = CircleProgressView.getMiddleValue(Color.red((int)prevColor), Color.red((int)curColor), factor);
        int g = CircleProgressView.getMiddleValue(Color.green((int)prevColor), Color.green((int)curColor), factor);
        int b = CircleProgressView.getMiddleValue(Color.blue((int)prevColor), Color.blue((int)curColor), factor);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    private static int getColor(Context context, int id2, int defaultValue) {
        TypedValue value = new TypedValue();
        try {
            Resources.Theme theme = context.getTheme();
            if (theme != null && theme.resolveAttribute(id2, value, true)) {
                if (value.type >= 16 && value.type <= 31) {
                    return value.data;
                }
                if (value.type == 3) {
                    return context.getResources().getColor(value.resourceId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    @TargetApi(value=21)
    public static int colorPrimary(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return CircleProgressView.getColor(context, 16843827, defaultValue);
        }
        return CircleProgressView.getColor(context, R.attr.colorPrimary, defaultValue);
    }

    static class CircularProgressDrawable
    extends Drawable
    implements Animatable {
        private long mLastUpdateTime;
        private long mLastProgressStateTime;
        private long mLastRunStateTime;
        private int mProgressState;
        private static final int PROGRESS_STATE_HIDE = -1;
        private static final int PROGRESS_STATE_STRETCH = 0;
        private static final int PROGRESS_STATE_KEEP_STRETCH = 1;
        private static final int PROGRESS_STATE_SHRINK = 2;
        private static final int PROGRESS_STATE_KEEP_SHRINK = 3;
        private int mRunState = 0;
        private static final int RUN_STATE_STOPPED = 0;
        private static final int RUN_STATE_STARTING = 1;
        private static final int RUN_STATE_STARTED = 2;
        private static final int RUN_STATE_RUNNING = 3;
        private static final int RUN_STATE_STOPPING = 4;
        private Paint mPaint;
        private RectF mRect;
        private float mStartAngle;
        private float mSweepAngle;
        private int mStrokeColorIndex;
        private int mPadding;
        private float mInitialAngle;
        private float mMaxSweepAngle;
        private float mMinSweepAngle;
        private int mStrokeSize;
        private int[] mStrokeColors;
        private boolean mReverse;
        private int mRotateDuration;
        private int mTransformDuration;
        private int mKeepDuration;
        private float mInStepPercent;
        private int[] mInColors;
        private int mInAnimationDuration;
        private int mOutAnimationDuration;
        private int mProgressMode;
        private Interpolator mTransformInterpolator;
        private final Runnable mUpdater = new Runnable(){

            @Override
            public void run() {
                CircularProgressDrawable.this.update();
            }
        };

        private CircularProgressDrawable(int padding, float initialAngle, float maxSweepAngle, float minSweepAngle, int strokeSize, int[] strokeColors, boolean reverse, int rotateDuration, int transformDuration, int keepDuration, Interpolator transformInterpolator, int progressMode, int inAnimDuration, float inStepPercent, int[] inStepColors, int outAnimDuration) {
            this.mPadding = padding;
            this.mInitialAngle = initialAngle;
            this.mMaxSweepAngle = maxSweepAngle;
            this.mMinSweepAngle = minSweepAngle;
            this.mStrokeSize = strokeSize;
            this.mStrokeColors = strokeColors;
            this.mReverse = reverse;
            this.mRotateDuration = rotateDuration;
            this.mTransformDuration = transformDuration;
            this.mKeepDuration = keepDuration;
            this.mTransformInterpolator = transformInterpolator;
            this.mProgressMode = progressMode;
            this.mInAnimationDuration = inAnimDuration;
            this.mInStepPercent = inStepPercent;
            this.mInColors = inStepColors;
            this.mOutAnimationDuration = outAnimDuration;
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mRect = new RectF();
        }

        public void draw(@NonNull Canvas canvas) {
            this.drawIndeterminate(canvas);
        }

        private int getIndeterminateStrokeColor() {
            if (this.mProgressState != 3 || this.mStrokeColors.length == 1) {
                return this.mStrokeColors[this.mStrokeColorIndex];
            }
            float value = Math.max(0.0f, Math.min(1.0f, (float)(SystemClock.uptimeMillis() - this.mLastProgressStateTime) / (float)this.mKeepDuration));
            int prev_index = this.mStrokeColorIndex == 0 ? this.mStrokeColors.length - 1 : this.mStrokeColorIndex - 1;
            return CircleProgressView.getMiddleColor(this.mStrokeColors[prev_index], this.mStrokeColors[this.mStrokeColorIndex], value);
        }

        private void drawIndeterminate(Canvas canvas) {
            if (this.mRunState == 1) {
                Rect bounds = this.getBounds();
                float x = (float)(bounds.left + bounds.right) / 2.0f;
                float y = (float)(bounds.top + bounds.bottom) / 2.0f;
                float maxRadius = (float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2) / 2.0f;
                float stepTime = 1.0f / (this.mInStepPercent * (float)(this.mInColors.length + 2) + 1.0f);
                float time = (float)(SystemClock.uptimeMillis() - this.mLastRunStateTime) / (float)this.mInAnimationDuration;
                float steps = time / stepTime;
                float outerRadius = 0.0f;
                float innerRadius = 0.0f;
                for (int i = (int)Math.floor(steps); i >= 0; --i) {
                    innerRadius = outerRadius;
                    outerRadius = Math.min(1.0f, (steps - (float)i) * this.mInStepPercent) * maxRadius;
                    if (i >= this.mInColors.length) continue;
                    if (innerRadius == 0.0f) {
                        this.mPaint.setColor(this.mInColors[i]);
                        this.mPaint.setStyle(Paint.Style.FILL);
                        canvas.drawCircle(x, y, outerRadius, this.mPaint);
                        continue;
                    }
                    if (!(outerRadius > innerRadius)) break;
                    float radius = (innerRadius + outerRadius) / 2.0f;
                    this.mRect.set(x - radius, y - radius, x + radius, y + radius);
                    this.mPaint.setStrokeWidth(outerRadius - innerRadius);
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    this.mPaint.setColor(this.mInColors[i]);
                    canvas.drawCircle(x, y, radius, this.mPaint);
                }
                if (this.mProgressState == -1) {
                    if (steps >= 1.0f / this.mInStepPercent || time >= 1.0f) {
                        this.resetAnimation();
                        this.mProgressState = 0;
                    }
                } else {
                    float radius = maxRadius - (float)this.mStrokeSize / 2.0f;
                    this.mRect.set(x - radius, y - radius, x + radius, y + radius);
                    this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    this.mPaint.setColor(this.getIndeterminateStrokeColor());
                    canvas.drawArc(this.mRect, this.mStartAngle, this.mSweepAngle, false, this.mPaint);
                }
            } else if (this.mRunState == 4) {
                float size = (float)this.mStrokeSize * (float)Math.max(0L, (long)this.mOutAnimationDuration - SystemClock.uptimeMillis() + this.mLastRunStateTime) / (float)this.mOutAnimationDuration;
                if (size > 0.0f) {
                    Rect bounds = this.getBounds();
                    float radius = ((float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2 - this.mStrokeSize * 2) + size) / 2.0f;
                    float x = (float)(bounds.left + bounds.right) / 2.0f;
                    float y = (float)(bounds.top + bounds.bottom) / 2.0f;
                    this.mRect.set(x - radius, y - radius, x + radius, y + radius);
                    this.mPaint.setStrokeWidth(size);
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    this.mPaint.setColor(this.getIndeterminateStrokeColor());
                    canvas.drawArc(this.mRect, this.mStartAngle, this.mSweepAngle, false, this.mPaint);
                }
            } else if (this.mRunState != 0) {
                Rect bounds = this.getBounds();
                float radius = (float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2 - this.mStrokeSize) / 2.0f;
                float x = (float)(bounds.left + bounds.right) / 2.0f;
                float y = (float)(bounds.top + bounds.bottom) / 2.0f;
                this.mRect.set(x - radius, y - radius, x + radius, y + radius);
                this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setColor(this.getIndeterminateStrokeColor());
                canvas.drawArc(this.mRect, this.mStartAngle, this.mSweepAngle, false, this.mPaint);
            }
        }

        public void setStrokeSize(int mStrokeSize) {
            this.mStrokeSize = mStrokeSize;
        }

        public void setStrokeColors(int[] mStrokeColors) {
            this.mStrokeColors = mStrokeColors;
        }

        public void setAlpha(int alpha) {
            this.mPaint.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter cf) {
            this.mPaint.setColorFilter(cf);
        }

        public int getOpacity() {
            return -3;
        }

        private void resetAnimation() {
            this.mLastProgressStateTime = this.mLastUpdateTime = SystemClock.uptimeMillis();
            this.mStartAngle = this.mInitialAngle;
            this.mStrokeColorIndex = 0;
            this.mSweepAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
        }

        public void start() {
            this.start(this.mInAnimationDuration > 0);
        }

        public void stop() {
            this.stop(this.mOutAnimationDuration > 0);
        }

        private void start(boolean withAnimation) {
            if (this.isRunning()) {
                return;
            }
            this.resetAnimation();
            if (withAnimation) {
                this.mRunState = 1;
                this.mLastRunStateTime = SystemClock.uptimeMillis();
                this.mProgressState = -1;
            }
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
            this.invalidateSelf();
        }

        private void stop(boolean withAnimation) {
            if (!this.isRunning()) {
                return;
            }
            if (withAnimation) {
                this.mLastRunStateTime = SystemClock.uptimeMillis();
                if (this.mRunState == 2) {
                    this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
                    this.invalidateSelf();
                }
                this.mRunState = 4;
            } else {
                this.mRunState = 0;
                this.unscheduleSelf(this.mUpdater);
                this.invalidateSelf();
            }
        }

        public boolean isRunning() {
            return this.mRunState != 0;
        }

        public void scheduleSelf(Runnable what, long when) {
            if (this.mRunState == 0) {
                this.mRunState = this.mInAnimationDuration > 0 ? 1 : 3;
            }
            super.scheduleSelf(what, when);
        }

        private void update() {
            switch (this.mProgressMode) {
                case 0: {
                    this.updateDeterminate();
                    break;
                }
                case 1: {
                    this.updateIndeterminate();
                }
            }
        }

        private void updateDeterminate() {
            long curTime = SystemClock.uptimeMillis();
            float rotateOffset = (float)(curTime - this.mLastUpdateTime) * 360.0f / (float)this.mRotateDuration;
            if (this.mReverse) {
                rotateOffset = -rotateOffset;
            }
            this.mLastUpdateTime = curTime;
            this.mStartAngle += rotateOffset;
            if (this.mRunState == 1) {
                if (curTime - this.mLastRunStateTime > (long)this.mInAnimationDuration) {
                    this.mRunState = 3;
                }
            } else if (this.mRunState == 4 && curTime - this.mLastRunStateTime > (long)this.mOutAnimationDuration) {
                this.stop(false);
                return;
            }
            if (this.isRunning()) {
                this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
            }
            this.invalidateSelf();
        }

        private void updateIndeterminate() {
            long curTime = SystemClock.uptimeMillis();
            float rotateOffset = (float)(curTime - this.mLastUpdateTime) * 360.0f / (float)this.mRotateDuration;
            if (this.mReverse) {
                rotateOffset = -rotateOffset;
            }
            this.mLastUpdateTime = curTime;
            switch (this.mProgressState) {
                case 0: {
                    if (this.mTransformDuration <= 0) {
                        this.mSweepAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
                        this.mProgressState = 1;
                        this.mStartAngle += rotateOffset;
                        this.mLastProgressStateTime = curTime;
                        break;
                    }
                    float value = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTransformDuration;
                    float maxAngle = this.mReverse ? -this.mMaxSweepAngle : this.mMaxSweepAngle;
                    float minAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
                    this.mStartAngle += rotateOffset;
                    this.mSweepAngle = this.mTransformInterpolator.getInterpolation(value) * (maxAngle - minAngle) + minAngle;
                    if (!(value > 1.0f)) break;
                    this.mSweepAngle = maxAngle;
                    this.mProgressState = 1;
                    this.mLastProgressStateTime = curTime;
                    break;
                }
                case 1: {
                    this.mStartAngle += rotateOffset;
                    if (curTime - this.mLastProgressStateTime <= (long)this.mKeepDuration) break;
                    this.mProgressState = 2;
                    this.mLastProgressStateTime = curTime;
                    break;
                }
                case 2: {
                    if (this.mTransformDuration <= 0) {
                        this.mSweepAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
                        this.mProgressState = 3;
                        this.mStartAngle += rotateOffset;
                        this.mLastProgressStateTime = curTime;
                        this.mStrokeColorIndex = (this.mStrokeColorIndex + 1) % this.mStrokeColors.length;
                        break;
                    }
                    float value = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTransformDuration;
                    float maxAngle = this.mReverse ? -this.mMaxSweepAngle : this.mMaxSweepAngle;
                    float minAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
                    float newSweepAngle = (1.0f - this.mTransformInterpolator.getInterpolation(value)) * (maxAngle - minAngle) + minAngle;
                    this.mStartAngle += rotateOffset + this.mSweepAngle - newSweepAngle;
                    this.mSweepAngle = newSweepAngle;
                    if (!(value > 1.0f)) break;
                    this.mSweepAngle = minAngle;
                    this.mProgressState = 3;
                    this.mLastProgressStateTime = curTime;
                    this.mStrokeColorIndex = (this.mStrokeColorIndex + 1) % this.mStrokeColors.length;
                    break;
                }
                case 3: {
                    this.mStartAngle += rotateOffset;
                    if (curTime - this.mLastProgressStateTime <= (long)this.mKeepDuration) break;
                    this.mProgressState = 0;
                    this.mLastProgressStateTime = curTime;
                }
            }
            if (this.mRunState == 1) {
                if (curTime - this.mLastRunStateTime > (long)this.mInAnimationDuration) {
                    this.mRunState = 3;
                    if (this.mProgressState == -1) {
                        this.resetAnimation();
                        this.mProgressState = 0;
                    }
                }
            } else if (this.mRunState == 4 && curTime - this.mLastRunStateTime > (long)this.mOutAnimationDuration) {
                this.stop(false);
                return;
            }
            if (this.isRunning()) {
                this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
            }
            this.invalidateSelf();
        }

        public static class Builder {
            private int mPadding;
            private float mInitialAngle;
            private float mMaxSweepAngle;
            private float mMinSweepAngle;
            private int mStrokeSize;
            private int[] mStrokeColors;
            private boolean mReverse;
            private int mRotateDuration;
            private int mTransformDuration;
            private int mKeepDuration;
            private Interpolator mTransformInterpolator;
            private int mProgressMode;
            private float mInStepPercent;
            private int[] mInColors;
            private int mInAnimationDuration;
            private int mOutAnimationDuration;

            public Builder(Context context, int defStyleRes) {
                this(context, null, 0, defStyleRes);
            }

            public Builder(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
                int j;
                int[] colors;
                TypedArray ta;
                TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CircularProgressDrawable, defStyleAttr, defStyleRes);
                this.padding(array.getDimensionPixelSize(R.styleable.CircularProgressDrawable_cpd_padding, 0));
                this.initialAngle(array.getInteger(R.styleable.CircularProgressDrawable_cpd_initialAngle, 0));
                this.maxSweepAngle(array.getInteger(R.styleable.CircularProgressDrawable_cpd_maxSweepAngle, 270));
                this.minSweepAngle(array.getInteger(R.styleable.CircularProgressDrawable_cpd_minSweepAngle, 1));
                this.strokeSize(array.getDimensionPixelSize(R.styleable.CircularProgressDrawable_cpd_strokeSize, (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context.getResources().getDisplayMetrics())));
                this.strokeColors(array.getColor(R.styleable.CircularProgressDrawable_cpd_strokeColor, CircleProgressView.colorPrimary(context, -16777216)));
                int resId = array.getResourceId(R.styleable.CircularProgressDrawable_cpd_strokeColors, 0);
                if (resId != 0) {
                    ta = context.getResources().obtainTypedArray(resId);
                    colors = new int[ta.length()];
                    for (j = 0; j < ta.length(); ++j) {
                        colors[j] = ta.getColor(j, 0);
                    }
                    ta.recycle();
                    this.strokeColors(colors);
                }
                this.reverse(array.getBoolean(R.styleable.CircularProgressDrawable_cpd_reverse, false));
                this.rotateDuration(array.getInteger(R.styleable.CircularProgressDrawable_cpd_rotateDuration, context.getResources().getInteger(17694722)));
                this.transformDuration(array.getInteger(R.styleable.CircularProgressDrawable_cpd_transformDuration, context.getResources().getInteger(0x10E0001)));
                this.keepDuration(array.getInteger(R.styleable.CircularProgressDrawable_cpd_keepDuration, context.getResources().getInteger(0x10E0000)));
                resId = array.getResourceId(R.styleable.CircularProgressDrawable_cpd_transformInterpolator, 0);
                if (resId != 0) {
                    this.transformInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
                }
                this.progressMode(array.getResourceId(R.styleable.CircularProgressDrawable_pv_progressMode, 1));
                this.inAnimDuration(array.getInteger(R.styleable.CircularProgressDrawable_cpd_inAnimDuration, context.getResources().getInteger(0x10E0001)));
                resId = array.getResourceId(R.styleable.CircularProgressDrawable_cpd_inStepColors, 0);
                if (resId != 0) {
                    ta = context.getResources().obtainTypedArray(resId);
                    colors = new int[ta.length()];
                    for (j = 0; j < ta.length(); ++j) {
                        colors[j] = ta.getColor(j, 0);
                    }
                    ta.recycle();
                    this.inStepColors(colors);
                }
                this.inStepPercent(array.getFloat(R.styleable.CircularProgressDrawable_cpd_inStepPercent, 0.5f));
                this.outAnimDuration(array.getInteger(R.styleable.CircularProgressDrawable_cpd_outAnimDuration, context.getResources().getInteger(0x10E0001)));
                array.recycle();
            }

            public CircularProgressDrawable build() {
                if (this.mStrokeColors == null) {
                    this.mStrokeColors = new int[]{-16737793};
                }
                if (this.mInColors == null && this.mInAnimationDuration > 0) {
                    this.mInColors = new int[]{-4860673, -2168068, -327682};
                }
                if (this.mTransformInterpolator == null) {
                    this.mTransformInterpolator = new DecelerateInterpolator();
                }
                return new CircularProgressDrawable(this.mPadding, this.mInitialAngle, this.mMaxSweepAngle, this.mMinSweepAngle, this.mStrokeSize, this.mStrokeColors, this.mReverse, this.mRotateDuration, this.mTransformDuration, this.mKeepDuration, this.mTransformInterpolator, this.mProgressMode, this.mInAnimationDuration, this.mInStepPercent, this.mInColors, this.mOutAnimationDuration);
            }

            public Builder padding(int padding) {
                this.mPadding = padding;
                return this;
            }

            public Builder initialAngle(float angle) {
                this.mInitialAngle = angle;
                return this;
            }

            public Builder maxSweepAngle(float angle) {
                this.mMaxSweepAngle = angle;
                return this;
            }

            public Builder minSweepAngle(float angle) {
                this.mMinSweepAngle = angle;
                return this;
            }

            public Builder strokeSize(int strokeSize) {
                this.mStrokeSize = strokeSize;
                return this;
            }

            public Builder strokeColors(int ... strokeColors) {
                this.mStrokeColors = strokeColors;
                return this;
            }

            public Builder reverse(boolean reverse) {
                this.mReverse = reverse;
                return this;
            }

            public Builder rotateDuration(int duration) {
                this.mRotateDuration = duration;
                return this;
            }

            public Builder transformDuration(int duration) {
                this.mTransformDuration = duration;
                return this;
            }

            public Builder keepDuration(int duration) {
                this.mKeepDuration = duration;
                return this;
            }

            public Builder transformInterpolator(Interpolator interpolator) {
                this.mTransformInterpolator = interpolator;
                return this;
            }

            public Builder progressMode(int mode) {
                this.mProgressMode = mode;
                return this;
            }

            public Builder inAnimDuration(int duration) {
                this.mInAnimationDuration = duration;
                return this;
            }

            public Builder inStepPercent(float percent) {
                this.mInStepPercent = percent;
                return this;
            }

            public Builder inStepColors(int ... colors) {
                this.mInColors = colors;
                return this;
            }

            public Builder outAnimDuration(int duration) {
                this.mOutAnimationDuration = duration;
                return this;
            }
        }
    }
}

