/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.hjq.base.BaseActivity;
import java.lang.reflect.Field;
import java.util.Random;

public abstract class BaseLazyFragment<A extends BaseActivity>
extends Fragment {
    public A mActivity;
    private View mRootView;
    private boolean isLazyLoad;
    private boolean isFragmentVisible;
    private boolean isReplaceFragment;
    private BaseActivity.ActivityCallback mActivityCallback;
    private int mActivityRequestCode;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mActivity = (BaseActivity)this.requireActivity();
    }

    public A getBindingActivity() {
        return this.mActivity;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ViewGroup parent;
        if (this.mRootView == null && this.getLayoutId() > 0) {
            this.mRootView = inflater.inflate(this.getLayoutId(), null);
        }
        if ((parent = (ViewGroup)this.mRootView.getParent()) != null) {
            parent.removeView(this.mRootView);
        }
        return this.mRootView;
    }

    public View getView() {
        return this.mRootView;
    }

    protected boolean isLazyLoad() {
        return this.isLazyLoad;
    }

    public boolean isFragmentVisible() {
        return this.isFragmentVisible;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.isReplaceFragment) {
            if (this.isFragmentVisible) {
                this.initLazyLoad();
            }
        } else {
            this.initLazyLoad();
        }
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        this.isReplaceFragment = true;
        this.isFragmentVisible = isVisibleToUser;
        if (isVisibleToUser && this.mRootView != null) {
            if (!this.isLazyLoad) {
                this.initLazyLoad();
            } else {
                this.onRestart();
            }
        }
    }

    protected void initLazyLoad() {
        if (!this.isLazyLoad) {
            this.isLazyLoad = true;
            this.initFragment();
        }
    }

    protected void onRestart() {
    }

    public void onDetach() {
        super.onDetach();
        try {
            Field childFragmentManager = Fragment.class.getDeclaredField("mChildFragmentManager");
            childFragmentManager.setAccessible(true);
            childFragmentManager.set((Object)this, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initFragment() {
        this.initView();
        this.initData();
    }

    protected abstract int getLayoutId();

    protected abstract int getTitleId();

    protected abstract void initView();

    protected abstract void initData();

    protected <V extends View> V findViewById(@IdRes int id) {
        return (V)this.mRootView.findViewById(id);
    }

    protected <V extends View> V findActivityViewById(@IdRes int id) {
        return (V)this.mActivity.findViewById(id);
    }

    public void startActivity(Class<? extends Activity> cls) {
        this.startActivity(new Intent(this.mActivity, cls));
    }

    public void startActivityFinish(Class<? extends Activity> cls) {
        this.startActivityFinish(new Intent(this.mActivity, cls));
    }

    public void startActivityFinish(Intent intent) {
        this.startActivity(intent);
        this.finish();
    }

    public void startActivityForResult(Class<? extends Activity> cls, BaseActivity.ActivityCallback callback) {
        this.startActivityForResult(new Intent(this.mActivity, cls), null, callback);
    }

    public void startActivityForResult(Intent intent, BaseActivity.ActivityCallback callback) {
        this.startActivityForResult(intent, null, callback);
    }

    public void startActivityForResult(Intent intent, Bundle options, BaseActivity.ActivityCallback callback) {
        if (this.mActivityCallback != null) {
            throw new IllegalArgumentException("Error, The callback is not over yet");
        }
        this.mActivityCallback = callback;
        this.mActivityRequestCode = new Random().nextInt(255);
        this.startActivityForResult(intent, this.mActivityRequestCode, options);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (this.mActivityCallback != null && this.mActivityRequestCode == requestCode) {
            this.mActivityCallback.onActivityResult(resultCode, data);
            this.mActivityCallback = null;
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void finish() {
        ((BaseActivity)((Object)this.mActivity)).finish();
        this.mActivity = null;
    }

    public <S> S getSystemService(@NonNull String name) {
        return (S)this.mActivity.getSystemService(name);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }
}

